package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jar.franchise.wrapper.CourseLessonWrapper;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseHo;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class CourseRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseHo CH = Tables.COURSE_HO;
	private static final com.jz.jooq.franchise.tables.CourseHoLesson CHL = Tables.COURSE_HO_LESSON;
	private static final com.jz.jooq.franchise.tables.CourseHoSchool CHS = Tables.COURSE_HO_SCHOOL;

	public List<CourseHo> getHoCourses(String brandId) {
		return franchiseCtx.selectFrom(CH).where(CH.BRAND_ID.eq(brandId)).fetchInto(CourseHo.class);
	}

	public CourseHo getHoCourse(String brandId, Integer courseId) {
		return franchiseCtx.selectFrom(CH).where(CH.BRAND_ID.eq(brandId).and(CH.COURSE_ID.eq(courseId)))
				.fetchAnyInto(CourseHo.class);
	}

	public List<CourseHo> mutiGetHoCourse(String brandId, Collection<Integer> courseIds) {
		return franchiseCtx.selectFrom(CH).where(CH.BRAND_ID.eq(brandId).and(CH.COURSE_ID.in(courseIds)))
				.fetchInto(CourseHo.class);
	}

	public List<CourseLessonWrapper> getHoLessons(String brandId, Integer courseId) {
		return franchiseCtx.select(CHL.LESSON_TIME, CHL.LESSON_TITLE).from(CHL)
				.where(CHL.BRAND_ID.eq(brandId).and(CHL.COURSE_ID.eq(courseId))).fetchInto(CourseLessonWrapper.class);
	}

	public List<CourseLessonWrapper> mutiGetHoLessons(String brandId, Collection<Integer> courseIds) {
		return franchiseCtx.select(CHL.COURSE_ID, CHL.LESSON_TIME, CHL.LESSON_TITLE).from(CHL)
				.where(CHL.BRAND_ID.eq(brandId).and(CHL.COURSE_ID.in(courseIds))).fetchInto(CourseLessonWrapper.class);
	}

	public List<Integer> getSchoolSpecCourseIds(String schoolId) {
		return franchiseCtx.select(CHS.COURSE_ID).from(CHS).where(CHS.SCHOOL_ID.eq(schoolId)).fetchInto(Integer.class);
	}

}
