package com.jz.jar.franchise.repository;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class ParentSchoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ParentSchool PS = Tables.PARENT_SCHOOL;

	public String getAdviser(String puid, String schoolId) {
		return franchiseCtx.select(PS.ADVISER).from(PS).where(PS.PUID.eq(puid).and(PS.SCHOOL_ID.eq(schoolId)))
				.fetchAnyInto(String.class);
	}
}
