/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityFqSubject;
import com.jz.jooq.franchise.tables.CouponInfo;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CouponInfoRepository
extends FranchiseBaseRepository {
    private static final CouponInfo CI = Tables.COUPON_INFO;
    private static final ActivityFqSubject AFS = Tables.ACTIVITY_FQ_SUBJECT;

    public List<com.jz.jooq.franchise.tables.pojos.CouponInfo> getCouponsByPuid(String puid, Integer filterUsageType) {
        Condition c = CouponInfoRepository.CI.PUID.eq((Object)puid);
        if (filterUsageType != null) {
            c = c.and(CouponInfoRepository.CI.USAGE_TYPE.eq((Object)filterUsageType));
        }
        return this.franchiseCtx.selectFrom((Table)CI).where(new Condition[]{CouponInfoRepository.CI.PUID.eq((Object)puid)}).orderBy(DSL.choose().when(CouponInfoRepository.CI.STATUS.eq((Object)0).and(CouponInfoRepository.CI.END_TIME.ge((Object)System.currentTimeMillis())), (Object)1).otherwise((Object)2).asc(), CouponInfoRepository.CI.CREATE_TIME.desc()).fetchInto(com.jz.jooq.franchise.tables.pojos.CouponInfo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.CouponInfo getCouponByCode(String couponCode) {
        return (com.jz.jooq.franchise.tables.pojos.CouponInfo)this.franchiseCtx.selectFrom((Table)CI).where(new Condition[]{CouponInfoRepository.CI.COUPON_CODE.eq((Object)couponCode)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.CouponInfo.class);
    }

    public void updateTransfer(String couponCode, String sourcePuid, String targetPuid) {
        this.franchiseCtx.update((Table)CI).set((Field)CouponInfoRepository.CI.PUID, (Object)targetPuid).set((Field)CouponInfoRepository.CI.SOURCE_PUID, (Object)sourcePuid).set((Field)CouponInfoRepository.CI.IS_TRANSFER, (Object)1).where(new Condition[]{CouponInfoRepository.CI.COUPON_CODE.eq((Object)couponCode)}).execute();
    }

    public Map<String, String> listSubjectId2NameMap() {
        return this.franchiseCtx.select((SelectField)CouponInfoRepository.AFS.SUBJECT_ID, (SelectField)CouponInfoRepository.AFS.SUBJECT_NAME).from((TableLike)AFS).fetchMap((Field)CouponInfoRepository.AFS.SUBJECT_ID, (Field)CouponInfoRepository.AFS.SUBJECT_NAME);
    }
}

