package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.FranchiseManageRepository;
import com.jz.jooq.franchise.tables.pojos.ManageSetting;

@Service
public class FranchiseManageService {

	@Autowired
	private FranchiseManageRepository manageRepository;

	public boolean isLeaveNoConsume(String schoolId) {
		// 蕃茄田走到下面
		ManageSetting ms = manageRepository.getManageSetting(schoolId);
		if (ms == null) {
			return true;
		}
		return ms.getLeaveConsumeType() == 2; // 1:课前请假耗课 2课前请假不耗课
	}

	public List<String> filterOnlineConsumeStudySchools(Collection<String> schoolIds) {
		return manageRepository.filterOnlineConsumeStudySchools(schoolIds);
	}

}
