package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.jar.franchise.repository.ContractCompanyRepository;
import com.jz.jooq.franchise.tables.pojos.ContractCompany;
import com.jz.jooq.franchise.tables.records.ContractCompanyRecord;

@Lazy
@Service
public class ContractCompanyService {

	@Autowired
	private ContractCompanyRepository contractCompanyRepository;

	public ContractCompany getContractCompany(String schoolId, Integer id) {
		return contractCompanyRepository.getContractCompany(schoolId, id);
	}

	public Map<String, Map<Integer, String>> mutiGetSchoolCompanyTable(Collection<String> schoolIds) {
		List<ContractCompany> cs = contractCompanyRepository.mutiGetContractCompany(schoolIds);
		Map<String, Map<Integer, String>> map = Maps.newHashMap();
		for (ContractCompany c : cs) {
			if (!map.containsKey(c.getSchoolId())) {
				map.put(c.getSchoolId(), Maps.newHashMap());
			}
			map.get(c.getSchoolId()).put(c.getId(), c.getCompany());
		}
		return map;
	}

	public int getMaxCompanyId(String schoolId) {
		return contractCompanyRepository.getMaxCompanyId(schoolId);
	}

	public void createContractCompany(ContractCompanyRecord record) {
		contractCompanyRepository.createContractCompany(record);
	}
}
