package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class FUserSchoolRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.FuserSchool FUS = Tables.FUSER_SCHOOL;

	public List<String> getEnableUids(List<String> allUids, String schoolId) {
		return franchiseCtx.select(FUS.FUID).from(FUS)
				.where(FUS.FUID.in(allUids).and(FUS.SCHOOL_ID.eq(schoolId)).and(FUS.STATUS.eq(1)))
				.fetchInto(String.class);
	}

	public List<String> getfuserSchoolIds(String fuid) {
		return franchiseCtx.select(FUS.SCHOOL_ID).from(FUS).where(FUS.FUID.eq(fuid).and(FUS.STATUS.eq(1)))
				.groupBy(FUS.SCHOOL_ID).fetchInto(String.class);
	}

	public void leaveSchools(String fuid, List<String> inSchoolIds) {
		franchiseCtx.update(FUS).set(FUS.STATUS, 2).where(FUS.FUID.eq(fuid).and(FUS.SCHOOL_ID.in(inSchoolIds)))
				.execute();
	}

}
