package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ContractPostpone;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class ContractPostponeRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ContractPostpone CP = Tables.CONTRACT_POSTPONE;

	public List<ContractPostpone> getPayedPostpones(String schoolId, String contractId) {
		return franchiseCtx.selectFrom(CP)
				.where(CP.SCHOOL_ID.eq(schoolId).and(CP.CONTRACT_ID.eq(contractId)).and(CP.STATUS.eq(1)))
				.orderBy(CP.ID.asc()).fetchInto(ContractPostpone.class);
	}

	public List<String> filterPayedContractIds(Collection<String> contractIds) {
		return franchiseCtx.select(CP.CONTRACT_ID).from(CP).where(CP.CONTRACT_ID.in(contractIds).and(CP.STATUS.eq(1)))
				.groupBy(CP.CONTRACT_ID).fetchInto(String.class);
	}

}
