package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ManageSetting;

/**
 * @author 连杰
 */
@Lazy
@Repository
public class FranchiseManageRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ManageSetting MS = Tables.MANAGE_SETTING;

	public ManageSetting getManageSetting(String schoolId) {
		return franchiseCtx.selectFrom(MS).where(MS.SCHOOL_ID.eq(schoolId)).fetchAnyInto(ManageSetting.class);
	}

	public List<String> filterOnlineFreeStudySchools(Collection<String> schoolIds) {
		return franchiseCtx.select(MS.SCHOOL_ID).from(MS)
				.where(MS.SCHOOL_ID.in(schoolIds).and(MS.ONLINE_STUDY_TYPE.eq(2))).fetchInto(String.class);
	}

	// 1关闭 2免费在线学习 3扣课在线学习
	public List<String> filterOnlineConsumeStudySchools(Collection<String> schoolIds) {
		return franchiseCtx.select(MS.SCHOOL_ID).from(MS)
				.where(MS.SCHOOL_ID.in(schoolIds).and(MS.ONLINE_STUDY_TYPE.eq(3))).fetchInto(String.class);
	}

}
