package com.jz.jar.franchise.wrapper;

import com.jz.jooq.franchise.tables.pojos.StudentInfo;

/**
 * 上传的例子解析实体
 */
public class CaseChildWrapper {

	private String name;
	private String sex;
	private String birthday;
	private String engName;
	private String kg;
	private String kgt;
	private Integer age;

	public static CaseChildWrapper of() {
		return new CaseChildWrapper();
	}

	public static CaseChildWrapper of(StudentInfo si) {
		return new CaseChildWrapper().setName(si.getName()).setSex(si.getSex()).setBirthday(si.getBirthday())
				.setEngName(si.getEngName()).setKg(si.getKg()).setKgt(si.getKgt());
	}

	public static CaseChildWrapper of(String name, String sex, String birthday) {
		return new CaseChildWrapper().setName(name).setSex(sex).setBirthday(birthday);
	}

	public String getName() {
		return name;
	}

	public CaseChildWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public CaseChildWrapper setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public CaseChildWrapper setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public String getEngName() {
		return engName;
	}

	public CaseChildWrapper setEngName(String engName) {
		this.engName = engName;
		return this;
	}

	public Integer getAge() {
		return age;
	}

	public CaseChildWrapper setAge(Integer age) {
		this.age = age;
		return this;
	}

	public String getKg() {
		return kg;
	}

	public CaseChildWrapper setKg(String kg) {
		this.kg = kg;
		return this;
	}

	public String getKgt() {
		return kgt;
	}

	public CaseChildWrapper setKgt(String kgt) {
		this.kgt = kgt;
		return this;
	}

}
