package com.jz.jar.franchise.wrapper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.jz.jooq.franchise.tables.pojos.Contract;
import com.jz.jooq.franchise.tables.pojos.ContractDetail;
import com.jz.jooq.franchise.tables.pojos.ContractTermsDetail;

public class ContractWrapper {

	private String contractId;
	private String schoolId;
	private String serialNum; // 流水号
	private ParentWrapper parent;//
	private Integer type;
	private CoursePackWrapper coursePack;//
	private Integer udType;
	private Collection<CourseWrapper> courses;
	private Integer totalPrice;
	private Integer materialFee;
	private Double totalDiscount;
	private Integer deposit;
	private Double finalFee;
	private Integer totalOfficalLesson;
	private Integer totalExtraLesson; // 赠课总数
	private Double onePrice;
	private Integer days;
	private Integer maxLeaveNum;
	private Long startTime;
	private Long endTime;
	private Integer status;
	private UserSimpleWrapper adviser;//
	private UserSimpleWrapper adviser2;//
	private Integer adviser2Rat;//
	private UserSimpleWrapper teacher;//
	private UserSimpleWrapper teacher2;
	private UserSimpleWrapper market;//
	private UserSimpleWrapper mentor;//
	private String remark;
	private Long created;
	private Long payTime;
	private BigDecimal refund;
	private Long refundTime;
	private UserPhoneWrapper introYg; //
	private StudentWrapper introHy; //
	private List<ContractStudentWrapper> students;
	private JSONArray originStudents;

	private String relContractId;
	private List<ContractWrapper> relContracts;

	private Integer parentSignStatus;
	private String upgradeSourceId;
	private Integer ver;
	private Integer scheType;
	private Integer maxPerWeek;
	private Integer giftDays;
	private Integer priority;
	private Integer auditDisplay;

	// detail信息，只有获取详情的时候才会获取
	private String faName;
	private String faPhone;
	private String faEmail;
	private String faCompany;
	private String moName;
	private String moPhone;
	private String moEmail;
	private String moCompany;
	private String address;
	private String receiptCode;
	private String paymentMode;
	private String giftId;
	private String giftName;
	private Integer giftValue;
	private Integer templateVer;

	// 是否可以退款和退订金
	private Boolean refundAble;
	private Boolean refundDepositAble;
	private Boolean printNoteAble;
	private Boolean postponeAble;

	private String originChannelId;
	private String originChannelName;

	private String contractChannelId;
	private String contractChannelName;

	private List<ContractPostponeWrapper> postpones;

	private Integer noScheduleOfficalLesson;

	private Integer consumeOfficalLesson; // 已消费正式课实数
	private Integer noConsumeOfficalLesson;
	private Integer consumeExtraLesson; // 已消费的赠课数
	private Integer noConsumeExtraLesson;

	private Integer totalLeftLesson; // 总剩余课时数
	private Integer extraLeftLesson; // 赠课剩余课时

	private SchoolWrapper school;

	// 已完结合同
	private Boolean isFinished;

	private String termsRemark;
	private Integer showLessonNum;
	private List<ContractTermsDetail> termsDetails;

	private String parentSignContent;

	private String partyA;
	private String partyB;

	private Integer receiptStatus;
	private String receiptRejectReason;

	public static ContractWrapper of(Contract c) {
		return new ContractWrapper().setContractId(c.getContractId()).setSchoolId(c.getSchoolId()).setType(c.getType())
				.setUdType(c.getUdType()).setTotalPrice(c.getTotalPrice()).setMaterialFee(c.getMaterialFee())
				.setDeposit(c.getDeposit()).setFinalFee(c.getFinalFee().doubleValue())
				.setTotalOfficalLesson(c.getTotalOfficalLesson()).setTotalExtraLesson(c.getTotalExtraLesson())
				.setOnePrice(c.getOnePrice().doubleValue()).setDays(c.getDays()).setMaxLeaveNum(c.getMaxLeaveNum())
				.setStartTime(c.getStartTime()).setEndTime(c.getEndTime()).setStatus(c.getStatus())
				.setRemark(c.getRemark()).setCreated(c.getCreated()).setPayTime(c.getPayTime())
				.setRefund(c.getRefund()).setRefundTime(c.getRefundTime()).setRelContractId(c.getRelContract())
				.setTotalDiscount(c.getTotalPrice() + c.getMaterialFee() - c.getFinalFee().doubleValue())
				.setParentSignStatus(c.getParentSignStatus()).setUpgradeSourceId(c.getUpgradeSourceId())
				.setVer(c.getVer()).setScheType(c.getScheType()).setMaxPerWeek(c.getMaxPerWeek())
				.setGiftDays(c.getGiftDays()).setPriority(c.getPriority()).setAuditDisplay(c.getAuditDisplay());
	}

	public ContractWrapper setContractDetail(ContractDetail cd) {
		return this.setFaName(cd.getFaName()).setFaPhone(cd.getFaPhone()).setFaEmail(cd.getFaEmail())
				.setFaCompany(cd.getFaCompany()).setMoName(cd.getMoName()).setMoPhone(cd.getMoPhone())
				.setMoEmail(cd.getMoEmail()).setMoCompany(cd.getMoCompany()).setAddress(cd.getAddress())
				.setReceiptCode(cd.getReceiptCode()).setPaymentMode(cd.getPaymentMode()).setGiftId(cd.getGiftId())
				.setGiftName(cd.getGiftName()).setGiftValue(cd.getGiftValue()).setTemplateVer(cd.getTemplateVer());
	}

	public String getContractId() {
		return contractId;
	}

	public ContractWrapper setContractId(String contractId) {
		this.contractId = contractId;
		return this;
	}

	public String getSchoolId() {
		return schoolId;
	}

	public ContractWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public ParentWrapper getParent() {
		return parent;
	}

	public ContractWrapper setParent(ParentWrapper parent) {
		this.parent = parent;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public ContractWrapper setType(Integer type) {
		this.type = type;
		return this;
	}

	public CoursePackWrapper getCoursePack() {
		return coursePack;
	}

	public ContractWrapper setCoursePack(CoursePackWrapper coursePack) {
		this.coursePack = coursePack;
		return this;
	}

	public Integer getTotalPrice() {
		return totalPrice;
	}

	public ContractWrapper setTotalPrice(Integer totalPrice) {
		this.totalPrice = totalPrice;
		return this;
	}

	public Integer getMaterialFee() {
		return materialFee;
	}

	public ContractWrapper setMaterialFee(Integer materialFee) {
		this.materialFee = materialFee;
		return this;
	}

	public Integer getDeposit() {
		return deposit;
	}

	public ContractWrapper setDeposit(Integer deposit) {
		this.deposit = deposit;
		return this;
	}

	public Double getFinalFee() {
		return finalFee;
	}

	public ContractWrapper setFinalFee(Double finalFee) {
		this.finalFee = finalFee;
		return this;
	}

	public Integer getTotalOfficalLesson() {
		return totalOfficalLesson;
	}

	public ContractWrapper setTotalOfficalLesson(Integer totalOfficalLesson) {
		this.totalOfficalLesson = totalOfficalLesson;
		return this;
	}

	public Integer getTotalExtraLesson() {
		return totalExtraLesson;
	}

	public ContractWrapper setTotalExtraLesson(Integer totalExtraLesson) {
		this.totalExtraLesson = totalExtraLesson;
		return this;
	}

	public Double getOnePrice() {
		return onePrice;
	}

	public ContractWrapper setOnePrice(Double onePrice) {
		this.onePrice = onePrice;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public ContractWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public ContractWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public ContractWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public UserSimpleWrapper getAdviser() {
		return adviser;
	}

	public ContractWrapper setAdviser(UserSimpleWrapper adviser) {
		this.adviser = adviser;
		return this;
	}

	public UserSimpleWrapper getTeacher() {
		return teacher;
	}

	public ContractWrapper setTeacher(UserSimpleWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public UserSimpleWrapper getMarket() {
		return market;
	}

	public ContractWrapper setMarket(UserSimpleWrapper market) {
		this.market = market;
		return this;
	}

	public Long getCreated() {
		return created;
	}

	public ContractWrapper setCreated(Long created) {
		this.created = created;
		return this;
	}

	public List<ContractStudentWrapper> getStudents() {
		return students;
	}

	public ContractWrapper setStudents(List<ContractStudentWrapper> students) {
		this.students = students;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public ContractWrapper setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getFaName() {
		return faName;
	}

	public ContractWrapper setFaName(String faName) {
		this.faName = faName;
		return this;
	}

	public String getFaPhone() {
		return faPhone;
	}

	public ContractWrapper setFaPhone(String faPhone) {
		this.faPhone = faPhone;
		return this;
	}

	public String getFaEmail() {
		return faEmail;
	}

	public ContractWrapper setFaEmail(String faEmail) {
		this.faEmail = faEmail;
		return this;
	}

	public String getFaCompany() {
		return faCompany;
	}

	public ContractWrapper setFaCompany(String faCompany) {
		this.faCompany = faCompany;
		return this;
	}

	public String getMoName() {
		return moName;
	}

	public ContractWrapper setMoName(String moName) {
		this.moName = moName;
		return this;
	}

	public String getMoPhone() {
		return moPhone;
	}

	public ContractWrapper setMoPhone(String moPhone) {
		this.moPhone = moPhone;
		return this;
	}

	public String getMoEmail() {
		return moEmail;
	}

	public ContractWrapper setMoEmail(String moEmail) {
		this.moEmail = moEmail;
		return this;
	}

	public String getMoCompany() {
		return moCompany;
	}

	public ContractWrapper setMoCompany(String moCompany) {
		this.moCompany = moCompany;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public ContractWrapper setAddress(String address) {
		this.address = address;
		return this;
	}

	public String getReceiptCode() {
		return receiptCode;
	}

	public ContractWrapper setReceiptCode(String receiptCode) {
		this.receiptCode = receiptCode;
		return this;
	}

	public String getPaymentMode() {
		return paymentMode;
	}

	public ContractWrapper setPaymentMode(String paymentMode) {
		this.paymentMode = paymentMode;
		return this;
	}

	public String getGiftName() {
		return giftName;
	}

	public ContractWrapper setGiftName(String giftName) {
		this.giftName = giftName;
		return this;
	}

	public Integer getGiftValue() {
		return giftValue;
	}

	public ContractWrapper setGiftValue(Integer giftValue) {
		this.giftValue = giftValue;
		return this;
	}

	public Integer getTemplateVer() {
		return templateVer;
	}

	public ContractWrapper setTemplateVer(Integer templateVer) {
		this.templateVer = templateVer;
		return this;
	}

	public Boolean getRefundAble() {
		return refundAble;
	}

	public ContractWrapper setRefundAble(Boolean refundAble) {
		this.refundAble = refundAble;
		return this;
	}

	public Boolean getRefundDepositAble() {
		return refundDepositAble;
	}

	public ContractWrapper setRefundDepositAble(Boolean refundDepositAble) {
		this.refundDepositAble = refundDepositAble;
		return this;
	}

	public Collection<CourseWrapper> getCourses() {
		return courses;
	}

	public ContractWrapper setCourses(Collection<CourseWrapper> courses) {
		this.courses = courses;
		return this;
	}

	public Long getPayTime() {
		return payTime;
	}

	public ContractWrapper setPayTime(Long payTime) {
		this.payTime = payTime;
		return this;
	}

	public Double getTotalDiscount() {
		return totalDiscount;
	}

	public ContractWrapper setTotalDiscount(Double totalDiscount) {
		this.totalDiscount = totalDiscount;
		return this;
	}

	public String getSerialNum() {
		return serialNum;
	}

	public ContractWrapper setSerialNum(String serialNum) {
		this.serialNum = serialNum;
		return this;
	}

	public Boolean getPrintNoteAble() {
		return printNoteAble;
	}

	public ContractWrapper setPrintNoteAble(Boolean printNoteAble) {
		this.printNoteAble = printNoteAble;
		return this;
	}

	public String getGiftId() {
		return giftId;
	}

	public ContractWrapper setGiftId(String giftId) {
		this.giftId = giftId;
		return this;
	}

	public UserSimpleWrapper getAdviser2() {
		return adviser2;
	}

	public ContractWrapper setAdviser2(UserSimpleWrapper adviser2) {
		this.adviser2 = adviser2;
		return this;
	}

	public Integer getAdviser2Rat() {
		return adviser2Rat;
	}

	public ContractWrapper setAdviser2Rat(Integer adviser2Rat) {
		this.adviser2Rat = adviser2Rat;
		return this;
	}

	public UserSimpleWrapper getTeacher2() {
		return teacher2;
	}

	public ContractWrapper setTeacher2(UserSimpleWrapper teacher2) {
		this.teacher2 = teacher2;
		return this;
	}

	public UserPhoneWrapper getIntroYg() {
		return introYg;
	}

	public ContractWrapper setIntroYg(UserPhoneWrapper introYg) {
		this.introYg = introYg;
		return this;
	}

	public StudentWrapper getIntroHy() {
		return introHy;
	}

	public ContractWrapper setIntroHy(StudentWrapper introHy) {
		this.introHy = introHy;
		return this;
	}

	public String getContractChannelId() {
		return contractChannelId;
	}

	public ContractWrapper setContractChannelId(String contractChannelId) {
		this.contractChannelId = contractChannelId;
		return this;
	}

	public String getContractChannelName() {
		return contractChannelName;
	}

	public ContractWrapper setContractChannelName(String contractChannelName) {
		this.contractChannelName = contractChannelName;
		return this;
	}

	public String getOriginChannelId() {
		return originChannelId;
	}

	public ContractWrapper setOriginChannelId(String originChannelId) {
		this.originChannelId = originChannelId;
		return this;
	}

	public String getOriginChannelName() {
		return originChannelName;
	}

	public ContractWrapper setOriginChannelName(String originChannelName) {
		this.originChannelName = originChannelName;
		return this;
	}

	public List<ContractPostponeWrapper> getPostpones() {
		return postpones;
	}

	public ContractWrapper setPostpones(List<ContractPostponeWrapper> postpones) {
		this.postpones = postpones;
		return this;
	}

	public Boolean getPostponeAble() {
		return postponeAble;
	}

	public ContractWrapper setPostponeAble(Boolean postponeAble) {
		this.postponeAble = postponeAble;
		return this;
	}

	public Integer getNoScheduleOfficalLesson() {
		return noScheduleOfficalLesson;
	}

	public ContractWrapper setNoScheduleOfficalLesson(Integer noScheduleOfficalLesson) {
		this.noScheduleOfficalLesson = noScheduleOfficalLesson;
		return this;
	}

	public Integer getConsumeOfficalLesson() {
		return consumeOfficalLesson;
	}

	public ContractWrapper setConsumeOfficalLesson(Integer consumeOfficalLesson) {
		this.consumeOfficalLesson = consumeOfficalLesson;
		return this;
	}

	public String getRelContractId() {
		return relContractId;
	}

	public ContractWrapper setRelContractId(String relContractId) {
		this.relContractId = relContractId;
		return this;
	}

	public List<ContractWrapper> getRelContracts() {
		return relContracts;
	}

	public ContractWrapper setRelContracts(List<ContractWrapper> relContracts) {
		this.relContracts = relContracts;
		return this;
	}

	public Boolean getIsFinished() {
		return isFinished;
	}

	public ContractWrapper setIsFinished(Boolean isFinished) {
		this.isFinished = isFinished;
		return this;
	}

	public Integer getUdType() {
		return udType;
	}

	public ContractWrapper setUdType(Integer udType) {
		this.udType = udType;
		return this;
	}

	public SchoolWrapper getSchool() {
		return school;
	}

	public ContractWrapper setSchool(SchoolWrapper school) {
		this.school = school;
		return this;
	}

	public UserSimpleWrapper getMentor() {
		return mentor;
	}

	public ContractWrapper setMentor(UserSimpleWrapper mentor) {
		this.mentor = mentor;
		return this;
	}

	public Integer getDays() {
		return days;
	}

	public ContractWrapper setDays(Integer days) {
		this.days = days;
		return this;
	}

	public List<ContractTermsDetail> getTermsDetails() {
		return termsDetails;
	}

	public ContractWrapper setTermsDetails(List<ContractTermsDetail> termsDetails) {
		this.termsDetails = termsDetails;
		return this;
	}

	public Integer getMaxLeaveNum() {
		return maxLeaveNum;
	}

	public ContractWrapper setMaxLeaveNum(Integer maxLeaveNum) {
		this.maxLeaveNum = maxLeaveNum;
		return this;
	}

	public Integer getTotalLeftLesson() {
		return totalLeftLesson;
	}

	public ContractWrapper setTotalLeftLesson(Integer totalLeftLesson) {
		this.totalLeftLesson = totalLeftLesson;
		return this;
	}

	public Integer getExtraLeftLesson() {
		return extraLeftLesson;
	}

	public ContractWrapper setExtraLeftLesson(Integer extraLeftLesson) {
		this.extraLeftLesson = extraLeftLesson;
		return this;
	}

	public Integer getNoConsumeOfficalLesson() {
		return noConsumeOfficalLesson;
	}

	public ContractWrapper setNoConsumeOfficalLesson(Integer noConsumeOfficalLesson) {
		this.noConsumeOfficalLesson = noConsumeOfficalLesson;
		return this;
	}

	public Integer getConsumeExtraLesson() {
		return consumeExtraLesson;
	}

	public ContractWrapper setConsumeExtraLesson(Integer consumeExtraLesson) {
		this.consumeExtraLesson = consumeExtraLesson;
		return this;
	}

	public Integer getNoConsumeExtraLesson() {
		return noConsumeExtraLesson;
	}

	public ContractWrapper setNoConsumeExtraLesson(Integer noConsumeExtraLesson) {
		this.noConsumeExtraLesson = noConsumeExtraLesson;
		return this;
	}

	public String getParentSignContent() {
		return parentSignContent;
	}

	public void setParentSignContent(String parentSignContent) {
		this.parentSignContent = parentSignContent;
	}

	public Integer getParentSignStatus() {
		return parentSignStatus;
	}

	public ContractWrapper setParentSignStatus(Integer parentSignStatus) {
		this.parentSignStatus = parentSignStatus;
		return this;
	}

	public String getTermsRemark() {
		return termsRemark;
	}

	public ContractWrapper setTermsRemark(String termsRemark) {
		this.termsRemark = termsRemark;
		return this;
	}

	public String getUpgradeSourceId() {
		return upgradeSourceId;
	}

	public ContractWrapper setUpgradeSourceId(String upgradeSourceId) {
		this.upgradeSourceId = upgradeSourceId;
		return this;
	}

	public Integer getVer() {
		return ver;
	}

	public ContractWrapper setVer(Integer ver) {
		this.ver = ver;
		return this;
	}

	public BigDecimal getRefund() {
		return refund;
	}

	public ContractWrapper setRefund(BigDecimal refund) {
		this.refund = refund;
		return this;
	}

	public Long getRefundTime() {
		return refundTime;
	}

	public ContractWrapper setRefundTime(Long refundTime) {
		this.refundTime = refundTime;
		return this;
	}

	public Integer getScheType() {
		return scheType;
	}

	public ContractWrapper setScheType(Integer scheType) {
		this.scheType = scheType;
		return this;
	}

	public String getPartyA() {
		return partyA;
	}

	public ContractWrapper setPartyA(String partyA) {
		this.partyA = partyA;
		return this;
	}

	public String getPartyB() {
		return partyB;
	}

	public ContractWrapper setPartyB(String partyB) {
		this.partyB = partyB;
		return this;
	}

	public Integer getMaxPerWeek() {
		return maxPerWeek;
	}

	public ContractWrapper setMaxPerWeek(Integer maxPerWeek) {
		this.maxPerWeek = maxPerWeek;
		return this;
	}

	public Integer getShowLessonNum() {
		return showLessonNum;
	}

	public ContractWrapper setShowLessonNum(Integer showLessonNum) {
		this.showLessonNum = showLessonNum;
		return this;
	}

	public Integer getGiftDays() {
		return giftDays;
	}

	public ContractWrapper setGiftDays(Integer giftDays) {
		this.giftDays = giftDays;
		return this;
	}

	public Integer getPriority() {
		return priority;
	}

	public ContractWrapper setPriority(Integer priority) {
		this.priority = priority;
		return this;
	}

	public Integer getAuditDisplay() {
		return auditDisplay;
	}

	public ContractWrapper setAuditDisplay(Integer auditDisplay) {
		this.auditDisplay = auditDisplay;
		return this;
	}

	public Integer getReceiptStatus() {
		return receiptStatus;
	}

	public ContractWrapper setReceiptStatus(Integer receiptStatus) {
		this.receiptStatus = receiptStatus;
		return this;
	}

	public JSONArray getOriginStudents() {
		return originStudents;
	}

	public ContractWrapper setOriginStudents(JSONArray originStudents) {
		this.originStudents = originStudents;
		return this;
	}

	public String getReceiptRejectReason() {
		return receiptRejectReason;
	}

	public ContractWrapper setReceiptRejectReason(String receiptRejectReason) {
		this.receiptRejectReason = receiptRejectReason;
		return this;
	}

}
