package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudentSatisfy;

@Lazy
@Repository
public class LessonStudentSatisfyRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.LessonStudentSatisfy LSS = Tables.LESSON_STUDENT_SATISFY;

	public void insUpdate(String schoolId, String lessonId, String suid, int roomLevel, String roomRemark,
			int techLevel, String techRemark, String content) {
		franchiseCtx
				.insertInto(LSS, LSS.SCHOOL_ID, LSS.LESSON_ID, LSS.SUID, LSS.ROOM_LEVEL, LSS.ROOM_REMARK,
						LSS.TECH_LEVEL, LSS.TECH_REMARK, LSS.CONTENT, LSS.CREATE_TIME)
				.values(schoolId, lessonId, suid, roomLevel, roomRemark, techLevel, techRemark, content,
						System.currentTimeMillis()).onDuplicateKeyUpdate().set(LSS.ROOM_LEVEL, roomLevel)
				.set(LSS.ROOM_REMARK, roomRemark).set(LSS.TECH_LEVEL, techLevel).set(LSS.TECH_REMARK, techRemark)
				.set(LSS.CONTENT, content).execute();
	}

	public LessonStudentSatisfy getBySchoolLessonSuid(String schoolId, String lessonId, String suid) {
		return franchiseCtx.selectFrom(LSS)
				.where(LSS.SCHOOL_ID.eq(schoolId).and(LSS.LESSON_ID.eq(lessonId)).and(LSS.SUID.eq(suid)))
				.fetchAnyInto(LessonStudentSatisfy.class);
	}

	public List<LessonStudentSatisfy> getBySuidLessonIds(String suid, Collection<String> lessonIds) {
		return franchiseCtx.selectFrom(LSS).where(LSS.SUID.eq(suid).and(LSS.LESSON_ID.in(lessonIds)))
				.fetchInto(LessonStudentSatisfy.class);
	}

	public List<String> getMadeLessonIds(String suid, Collection<String> lessonIds) {
		return franchiseCtx.select(LSS.LESSON_ID).from(LSS).where(LSS.SUID.eq(suid).and(LSS.LESSON_ID.in(lessonIds)))
				.fetchInto(String.class);
	}

}
