package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.cache.LessonCache;
import com.jz.jar.franchise.repository.LessonRepository;
import com.jz.jooq.franchise.tables.pojos.Lesson;

@Lazy
@Service
public class LessonService {

	@Autowired
	private LessonRepository lessonRepository;
	@Autowired
	private LessonCache lessonCache;

	public List<Lesson> findLesson(Map<String, Collection<String>> school2Lessons) {
		Map<String, Collection<String>> tempKeys = Maps.newHashMap(school2Lessons);
		List<Lesson> cacheLesson = lessonCache.getLesson(school2Lessons);
		if (ArrayMapTools.isNotEmpty(cacheLesson)) {
			cacheLesson.forEach(it -> {
				// 清理已经从缓存中获取到数据的lessonId
					tempKeys.get(it.getSchoolId()).remove(it.getLessonId());
					// 如果当前school下的课程全部从缓存中获取到了，则清理该school
					if (tempKeys.get(it.getSchoolId()).isEmpty()) {
						tempKeys.remove(it.getSchoolId());
					}
				});
		}

		// 全部从缓存中获取到了
		if (ArrayMapTools.isEmpty(tempKeys))
			return cacheLesson;

		List<Lesson> dbLesson = lessonRepository.findLesson(tempKeys);
		if (ArrayMapTools.isEmpty(dbLesson))
			return cacheLesson;
		lessonCache.setLesson(dbLesson);
		cacheLesson.addAll(dbLesson);
		return cacheLesson;
	}

	/** 当前可是是否已经开始 */
	public Lesson getLesson(String schoolId, String lessonId) {
		Lesson lesson = lessonCache.getLesson(schoolId, lessonId);
		if (null != lesson)
			return lesson;
		lesson = lessonRepository.getLesson(schoolId, lessonId);
		if (null == lesson)
			return null;
		lessonCache.setLesson(lesson);
		return lesson;
	}

	public List<Lesson> findLesson(Map<String, Collection<String>> school2Lessons, boolean asc, Long currentTimeMillis,
			int start, int size) {
		return lessonRepository.findLesson(school2Lessons, asc, currentTimeMillis, start, size);
	}

	public int countLesson(Map<String, Collection<String>> school2Lessons, Long currentTimeMillis) {
		return lessonRepository.countLesson(school2Lessons, currentTimeMillis);
	}

	public Lesson findOneTodayLesson(Map<String, Collection<String>> school2Lessons, long startTime, long endTime) {
		return lessonRepository.findOneTodayLesson(school2Lessons, startTime, endTime);
	}

}
