/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import com.jz.jooq.franchise.tables.records.LessonStudentRecord;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LessonStudentRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.LessonStudent LS = Tables.LESSON_STUDENT;
    private static List<TableField<LessonStudentRecord, ?>> simpleFields = Arrays.asList(LessonStudentRepository.LS.SCHOOL_ID, LessonStudentRepository.LS.BRAND_ID, LessonStudentRepository.LS.LESSON_ID, LessonStudentRepository.LS.STATUS, LessonStudentRepository.LS.TYPE, LessonStudentRepository.LS.CONTRACT_ID, LessonStudentRepository.LS.EXTRA_ID, LessonStudentRepository.LS.NEED_CONSUME_JSON);

    public List<LessonStudent> findSimpleInfo(String suid, String brandId, Collection<Integer> statuses) {
        Condition condition = LessonStudentRepository.LS.SUID.eq((Object)suid).and(LessonStudentRepository.LS.BRAND_ID.eq((Object)brandId));
        if (ArrayMapTools.isNotEmpty(statuses)) {
            condition = condition.and(LessonStudentRepository.LS.STATUS.in(statuses));
        }
        return this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{condition}).fetchInto(LessonStudent.class);
    }

    public LessonStudent getSimpleLessonStudent(String schoolId, String lessonId, String suid) {
        return (LessonStudent)this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).fetchAnyInto(LessonStudent.class);
    }

    public LessonStudent getLessonStudent(String schoolId, String lessonId, String suid) {
        return (LessonStudent)this.franchiseCtx.selectFrom((Table)LS).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).fetchAnyInto(LessonStudent.class);
    }

    public void updateStatus(String schoolId, String lessonId, String suid, int status) {
        this.franchiseCtx.update((Table)LS).set((Field)LessonStudentRepository.LS.STATUS, (Object)status).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).execute();
    }

    public void updateContractStatus(String schoolId, String lessonId, String suid, String contractId, Integer extraId, String needConsumeJson, int status) {
        this.franchiseCtx.update((Table)LS).set((Field)LessonStudentRepository.LS.STATUS, (Object)status).set((Field)LessonStudentRepository.LS.CONTRACT_ID, (Object)contractId).set((Field)LessonStudentRepository.LS.EXTRA_ID, (Object)extraId).set((Field)LessonStudentRepository.LS.NEED_CONSUME_JSON, (Object)needConsumeJson).where(new Condition[]{LessonStudentRepository.LS.SCHOOL_ID.eq((Object)schoolId).and(LessonStudentRepository.LS.LESSON_ID.eq((Object)lessonId)).and(LessonStudentRepository.LS.SUID.eq((Object)suid))}).execute();
    }

    public List<LessonStudent> findSimpleFinishedLessonInfo(String suid, String brandId) {
        return this.franchiseCtx.select(simpleFields).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid).and(LessonStudentRepository.LS.BRAND_ID.eq((Object)brandId)).and(LessonStudentRepository.LS.TYPE.eq((Object)1)).and(LessonStudentRepository.LS.STATUS.in((Object[])new Integer[]{1, 2, 4}))}).fetchInto(LessonStudent.class);
    }

    public List<LessonStudent> getWaitSignLessonIdSchoolId(String suid, String brandId) {
        return this.franchiseCtx.select((SelectField)LessonStudentRepository.LS.SCHOOL_ID, (SelectField)LessonStudentRepository.LS.LESSON_ID).from((TableLike)LS).where(new Condition[]{LessonStudentRepository.LS.SUID.eq((Object)suid).and(LessonStudentRepository.LS.BRAND_ID.eq((Object)brandId)).and(LessonStudentRepository.LS.STATUS.eq((Object)0))}).fetchInto(LessonStudent.class);
    }
}

