package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.FuserInfo;

@Lazy
@Repository
public class FUserInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.FuserInfo FU = Tables.FUSER_INFO;

	public List<FuserInfo> getTeachers(Collection<String> uids) {
		return franchiseCtx.select(FU.UID, FU.PIC_ADDRESS, FU.CHINESE_NAME, FU.ENGLISH_NAME).from(FU)
				.where(FU.UID.in(uids)).fetchInto(FuserInfo.class);
	}

	public List<FuserInfo> mutiGetUserInfo(Collection<String> uids) {
		return franchiseCtx.selectFrom(FU).where(FU.UID.in(uids)).fetchInto(FuserInfo.class);
	}

	public FuserInfo getTeacher(String uid) {
		return franchiseCtx.select(FU.UID, FU.PIC_ADDRESS, FU.CHINESE_NAME, FU.ENGLISH_NAME).from(FU)
				.where(FU.UID.eq(uid)).fetchAnyInto(FuserInfo.class);
	}

	public String getUserPwd(String uid) {
		return franchiseCtx.select(FU.PASSWORD).from(FU).where(FU.UID.eq(uid)).fetchAnyInto(String.class);
	}

	public void updateIsHo(String uid, int ho) {
		franchiseCtx.update(FU).set(FU.IS_HO, ho).where(FU.UID.eq(uid)).execute();
	}

	public FuserInfo getFuserInfo(String uid) {
		return franchiseCtx.selectFrom(FU).where(FU.UID.eq(uid)).fetchAnyInto(FuserInfo.class);
	}
}
