package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Region;
import com.jz.jooq.franchise.tables.records.RegionRecord;

@Lazy
@Repository
public class RegionRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.Region R = Tables.REGION;

	public void deleteSettings(String uid, String taker) {
		franchiseCtx.update(R).set(R.FOC, taker).where(R.FOC.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FOA, taker).where(R.FOA.eq(uid)).execute();
		franchiseCtx.update(R).set(R.FM, taker).where(R.FM.eq(uid)).execute();
		franchiseCtx.update(R).set(R.SALE, taker).where(R.SALE.eq(uid)).execute();
	}

	public List<Region> getFinSettings(String uid) {
		return franchiseCtx.selectFrom(R)
				.where(R.FIN_DIRECT.like("%" + uid + "%").or(R.FIN_FRANCHISE.like("%" + uid + "%")))
				.fetchInto(Region.class);
	}

	public void updateFins(List<RegionRecord> records) {
		franchiseCtx.batchUpdate(records).execute();
	}

}
