/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.School;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SchoolRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.School SC = Tables.SCHOOL;

    public School getSchool(String id) {
        return (School)this.franchiseCtx.selectFrom((Table)SC).where(new Condition[]{SchoolRepository.SC.ID.eq((Object)id)}).fetchAnyInto(School.class);
    }

    public List<School> getSimpleSchool(Collection<String> ids) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)SchoolRepository.SC.CENTER_NAME, (SelectField)SchoolRepository.SC.CENTER_ADDRESS, (SelectField)SchoolRepository.SC.PHONE).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.in(ids)}).fetchInto(School.class);
    }

    private Condition getCondition(String brand) {
        return SchoolRepository.SC.BRAND_ID.eq((Object)brand).and(SchoolRepository.SC.STATUS.eq((Object)1).and(SchoolRepository.SC.LAST_CONTRACT.ne((Object)1)).or(SchoolRepository.SC.STATUS.eq((Object)4))).and(SchoolRepository.SC.CODE.ge((Object)100));
    }

    private Condition getSchoolCondition(String brand, String prov, String city, boolean isReservation) {
        Condition condition = this.getCondition(brand);
        if (StringTools.isNotEmpty((CharSequence)prov)) {
            condition = condition.and(SchoolRepository.SC.PROV.eq((Object)prov));
        }
        if (StringTools.isNotEmpty((CharSequence)city)) {
            condition = condition.and(SchoolRepository.SC.CITY.eq((Object)city));
        }
        if (isReservation) {
            condition = condition.and(SchoolRepository.SC.CENTER_NAME.isNotNull()).and(SchoolRepository.SC.CENTER_NAME.ne((Object)""));
        }
        return condition;
    }

    public List<School> getSchoolAreas(String brand, boolean isReservation) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.PROV, (SelectField)SchoolRepository.SC.CITY, (SelectField)DSL.count((Field)DSL.one()).as((Field)SchoolRepository.SC.CITY_LEVEL)).from((TableLike)SC).where(new Condition[]{this.getSchoolCondition(brand, null, null, isReservation)}).groupBy(new GroupField[]{SchoolRepository.SC.PROV, SchoolRepository.SC.CITY}).orderBy(DSL.choose((Field)SchoolRepository.SC.PROV).when((Object)"\u5317\u4eac", (Object)9999).when((Object)"\u4e0a\u6d77", (Object)8888).when((Object)"\u5e7f\u4e1c", (Object)7777).otherwise((Field)DSL.count((Field)DSL.one())).desc()).fetchInto(School.class);
    }

    public List<School> getSchools(String brand, String prov, String city, boolean isReservation) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)DSL.choose().when(SchoolRepository.SC.STATUS.eq((Object)1), (Field)SchoolRepository.SC.CENTER_NAME).otherwise(DSL.concat((Field)SchoolRepository.SC.CENTER_NAME, (String)"(\u5e97\u94fa\u5347\u7ea7\u4e2d)")).as((Field)SchoolRepository.SC.CENTER_NAME), (SelectField)SchoolRepository.SC.CENTER_ADDRESS, (SelectField)SchoolRepository.SC.PHONE, (SelectField)SchoolRepository.SC.LAT, (SelectField)SchoolRepository.SC.LNG).from((TableLike)SC).where(new Condition[]{this.getSchoolCondition(brand, prov, city, isReservation)}).orderBy(DSL.choose().when(SchoolRepository.SC.OPEN_TIME.isNotNull().and(SchoolRepository.SC.OPEN_TIME.lt((Object)System.currentTimeMillis())).and(SchoolRepository.SC.STATUS.eq((Object)1)), (Object)1).otherwise((Object)2).asc(), SchoolRepository.SC.CODE.desc()).fetchInto(School.class);
    }

    public List<School> getSchoolForName(String brand, String schoolName) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)DSL.choose().when(SchoolRepository.SC.STATUS.eq((Object)1), (Field)SchoolRepository.SC.CENTER_NAME).otherwise(DSL.concat((Field)SchoolRepository.SC.CENTER_NAME, (String)"(\u5e97\u94fa\u5347\u7ea7\u4e2d)")).as((Field)SchoolRepository.SC.CENTER_NAME), (SelectField)SchoolRepository.SC.CENTER_ADDRESS, (SelectField)SchoolRepository.SC.PHONE, (SelectField)SchoolRepository.SC.LAT, (SelectField)SchoolRepository.SC.LNG).from((TableLike)SC).where(new Condition[]{this.getCondition(brand).and(SchoolRepository.SC.CENTER_NAME.like("%" + schoolName + "%"))}).orderBy(SchoolRepository.SC.CODE.desc()).fetchInto(School.class);
    }

    public String getSchoolName(String id) {
        return (String)this.franchiseCtx.select((SelectField)SchoolRepository.SC.CENTER_NAME).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.eq((Object)id).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchAnyInto(String.class);
    }

    public List<String> getSchoolIdForBrand(String brand) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.BRAND_ID.eq((Object)brand).and(SchoolRepository.SC.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public Map<String, String> mutiGetId2NameMap(Collection<String> schoolIds) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID, (SelectField)SchoolRepository.SC.NAME).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.in(schoolIds)}).fetchMap((Field)SchoolRepository.SC.ID, (Field)SchoolRepository.SC.NAME);
    }

    public List<String> filterSchoolIdByBrand(Collection<String> schoolIds, String brandId) {
        return this.franchiseCtx.select((SelectField)SchoolRepository.SC.ID).from((TableLike)SC).where(new Condition[]{SchoolRepository.SC.ID.in(schoolIds).and(SchoolRepository.SC.BRAND_ID.eq((Object)brandId))}).fetchInto(String.class);
    }
}

