package com.jz.jar.franchise.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.CourseTomatoTopicRepository;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoTopic;

@Lazy
@Service
public class CourseTomatoTopicService {

	@Autowired
	private CourseTomatoTopicRepository courseTomatoTopicRepository;

	public int countTopics(String branchId) {
		return courseTomatoTopicRepository.countTopics(branchId);
	}

	public List<CourseTomatoTopic> findTopics(String branchId, int start, int size) {
		return courseTomatoTopicRepository.findTopics(branchId, start, size);
	}
	
	public CourseTomatoTopic getTopic(String branchId, String tid) {
		return courseTomatoTopicRepository.getTopic(branchId, tid);
	}

}
