package com.jz.jar.franchise.wrapper;

import java.util.List;
import java.util.Map;

import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentSchool;

public class StudentWrapper {

	// 基础信息
	private Integer code;
	private String suid;
	private String name;
	private String sex;
	private String birthday;
	private String age;
	private String engName;
	private String kg;
	private String kgt;
	private String avatar; // 要单独set

	// 分校下信息
	private Integer status; // 需要特殊处理
	private Long stopStartTime;
	private Long stopEndTime;
	private UserSimpleWrapper adviser; // 需要特殊处理
	private UserSimpleWrapper teacher; // 需要特殊处理
	private UserSimpleWrapper teacher2; // 需要特殊处理
	private UserSimpleWrapper mentor; // 需要特殊处理
	private Long firstContractTime;
	private String remark;
	private Integer caseCommNum;
	private Integer stuCommNum;
	private Long lastCommunicateTime;
	private String lastCommunicateRs; // 需要特殊处理

	private Integer recomNum;
	private Integer introNum;
	private Long introTime;
	private Integer monthCommunicateNum;

	// 家长信息
	private String puid;
	private String parentName;
	private String phone;
	private String relation;
	private String address;
	private String district;
	private String otherContact;

	// 合同信息
	private List<StudentContractWrapper> contracts;
	private List<CourseWrapper> levels;

	private List<Map<String, Object>> relParents;

	private Integer totalLessonNum;
	private Integer totalConsumeNum;

	private Integer totalExtraNum;
	private Integer totalExtraConsumeNum;

	private Integer totalLeftNum;
	private Double totalLeftMoney;

	private Long contractEndTime;// 最后一份合同到期时间

	private Boolean signApp; // 是否登陆过app

	public static StudentWrapper of(StudentInfo si) {
		return new StudentWrapper().setStudentInfo(si);
	}

	public static StudentWrapper ofBase(StudentInfo si) {
		return new StudentWrapper().setSuid(si.getSuid()).setName(si.getName());
	}

	public static StudentWrapper of(StudentSchool ss) {
		StudentWrapper wrapper = new StudentWrapper().setSuid(ss.getSuid()).setRemark(ss.getRemark());
		if (ss.getStopStartTime() > 0 && ss.getStopEndTime() > 0) {
			wrapper.setStopStartTime(ss.getStopStartTime()).setStopEndTime(ss.getStopEndTime());
		}
		if (ss.getFirstContractTime() > 0) {
			wrapper.setFirstContractTime(ss.getFirstContractTime());
		}
		wrapper.setCaseCommNum(ss.getCaseCommNum());
		wrapper.setStuCommNum(ss.getStuCommNum());
		wrapper.setLastCommunicateTime(ss.getLastCommunicateTime());
		wrapper.setRecomNum(ss.getRecomNum()).setIntroNum(ss.getIntroNum()).setIntroTime(ss.getIntroTime());
		return wrapper;
	}

	public StudentWrapper setStudentInfo(StudentInfo si) {
		this.setSuid(si.getSuid()).setCode(si.getCode()).setName(si.getName()).setSex(si.getSex())
				.setBirthday(si.getBirthday()).setEngName(si.getEngName()).setKg(si.getKg()).setKgt(si.getKgt());
		return this;
	}

	public StudentWrapper setParentInfo(ParentInfo pi) {
		return this.setPuid(pi.getPuid()).setParentName(pi.getName()).setPhone(pi.getPhone())
				.setRelation(pi.getRelation()).setAddress(pi.getAddress()).setDistrict(pi.getDistrict())
				.setOtherContact(pi.getOtherContact());
	}

	public String getSuid() {
		return suid;
	}

	public StudentWrapper setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public StudentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public StudentWrapper setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public StudentWrapper setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public String getAge() {
		return age;
	}

	public StudentWrapper setAge(String age) {
		this.age = age;
		return this;
	}

	public String getEngName() {
		return engName;
	}

	public StudentWrapper setEngName(String engName) {
		this.engName = engName;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public StudentWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Long getStopStartTime() {
		return stopStartTime;
	}

	public StudentWrapper setStopStartTime(Long stopStartTime) {
		this.stopStartTime = stopStartTime;
		return this;
	}

	public Long getStopEndTime() {
		return stopEndTime;
	}

	public StudentWrapper setStopEndTime(Long stopEndTime) {
		this.stopEndTime = stopEndTime;
		return this;
	}

	public UserSimpleWrapper getAdviser() {
		return adviser;
	}

	public StudentWrapper setAdviser(UserSimpleWrapper adviser) {
		this.adviser = adviser;
		return this;
	}

	public UserSimpleWrapper getTeacher() {
		return teacher;
	}

	public StudentWrapper setTeacher(UserSimpleWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public List<StudentContractWrapper> getContracts() {
		return contracts;
	}

	public StudentWrapper setContracts(List<StudentContractWrapper> contracts) {
		this.contracts = contracts;
		return this;
	}

	public Long getFirstContractTime() {
		return firstContractTime;
	}

	public StudentWrapper setFirstContractTime(Long firstContractTime) {
		this.firstContractTime = firstContractTime;
		return this;
	}

	public String getParentName() {
		return parentName;
	}

	public StudentWrapper setParentName(String parentName) {
		this.parentName = parentName;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public StudentWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getRelation() {
		return relation;
	}

	public StudentWrapper setRelation(String relation) {
		this.relation = relation;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public StudentWrapper setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public StudentWrapper setAddress(String address) {
		this.address = address;
		return this;
	}

	public String getPuid() {
		return puid;
	}

	public StudentWrapper setPuid(String puid) {
		this.puid = puid;
		return this;
	}

	public String getKg() {
		return kg;
	}

	public StudentWrapper setKg(String kg) {
		this.kg = kg;
		return this;
	}

	public String getKgt() {
		return kgt;
	}

	public StudentWrapper setKgt(String kgt) {
		this.kgt = kgt;
		return this;
	}

	public String getDistrict() {
		return district;
	}

	public StudentWrapper setDistrict(String district) {
		this.district = district;
		return this;
	}

	public UserSimpleWrapper getTeacher2() {
		return teacher2;
	}

	public StudentWrapper setTeacher2(UserSimpleWrapper teacher2) {
		this.teacher2 = teacher2;
		return this;
	}

	public Integer getCode() {
		return code;
	}

	public StudentWrapper setCode(Integer code) {
		this.code = code;
		return this;
	}

	public Integer getCaseCommNum() {
		return caseCommNum;
	}

	public StudentWrapper setCaseCommNum(Integer caseCommNum) {
		this.caseCommNum = caseCommNum;
		return this;
	}

	public Integer getStuCommNum() {
		return stuCommNum;
	}

	public StudentWrapper setStuCommNum(Integer stuCommNum) {
		this.stuCommNum = stuCommNum;
		return this;
	}

	public Integer getTotalLessonNum() {
		return totalLessonNum;
	}

	public StudentWrapper setTotalLessonNum(Integer totalLessonNum) {
		this.totalLessonNum = totalLessonNum;
		return this;
	}

	public Integer getTotalConsumeNum() {
		return totalConsumeNum;
	}

	public StudentWrapper setTotalConsumeNum(Integer totalConsumeNum) {
		this.totalConsumeNum = totalConsumeNum;
		return this;
	}

	public String getOtherContact() {
		return otherContact;
	}

	public StudentWrapper setOtherContact(String otherContact) {
		this.otherContact = otherContact;
		return this;
	}

	public UserSimpleWrapper getMentor() {
		return mentor;
	}

	public StudentWrapper setMentor(UserSimpleWrapper mentor) {
		this.mentor = mentor;
		return this;
	}

	public Long getLastCommunicateTime() {
		return lastCommunicateTime;
	}

	public StudentWrapper setLastCommunicateTime(Long lastCommunicateTime) {
		this.lastCommunicateTime = lastCommunicateTime;
		return this;
	}

	public String getLastCommunicateRs() {
		return lastCommunicateRs;
	}

	public StudentWrapper setLastCommunicateRs(String lastCommunicateRs) {
		this.lastCommunicateRs = lastCommunicateRs;
		return this;
	}

	public Integer getTotalExtraNum() {
		return totalExtraNum;
	}

	public StudentWrapper setTotalExtraNum(Integer totalExtraNum) {
		this.totalExtraNum = totalExtraNum;
		return this;
	}

	public Integer getTotalExtraConsumeNum() {
		return totalExtraConsumeNum;
	}

	public StudentWrapper setTotalExtraConsumeNum(Integer totalExtraConsumeNum) {
		this.totalExtraConsumeNum = totalExtraConsumeNum;
		return this;
	}

	public Integer getTotalLeftNum() {
		return totalLeftNum;
	}

	public StudentWrapper setTotalLeftNum(Integer totalLeftNum) {
		this.totalLeftNum = totalLeftNum;
		return this;
	}

	public List<CourseWrapper> getLevels() {
		return levels;
	}

	public StudentWrapper setLevels(List<CourseWrapper> levels) {
		this.levels = levels;
		return this;
	}

	public Double getTotalLeftMoney() {
		return totalLeftMoney;
	}

	public StudentWrapper setTotalLeftMoney(Double totalLeftMoney) {
		this.totalLeftMoney = totalLeftMoney;
		return this;
	}

	public String getAvatar() {
		return avatar;
	}

	public StudentWrapper setAvatar(String avatar) {
		this.avatar = avatar;
		return this;
	}

	public List<Map<String, Object>> getRelParents() {
		return relParents;
	}

	public StudentWrapper setRelParents(List<Map<String, Object>> relParents) {
		this.relParents = relParents;
		return this;
	}

	public Long getContractEndTime() {
		return contractEndTime;
	}

	public StudentWrapper setContractEndTime(Long contractEndTime) {
		this.contractEndTime = contractEndTime;
		return this;
	}

	public Integer getRecomNum() {
		return recomNum;
	}

	public StudentWrapper setRecomNum(Integer recomNum) {
		this.recomNum = recomNum;
		return this;
	}

	public Integer getIntroNum() {
		return introNum;
	}

	public StudentWrapper setIntroNum(Integer introNum) {
		this.introNum = introNum;
		return this;
	}

	public Long getIntroTime() {
		return introTime;
	}

	public StudentWrapper setIntroTime(Long introTime) {
		this.introTime = introTime;
		return this;
	}

	public Boolean getSignApp() {
		return signApp;
	}

	public StudentWrapper setSignApp(Boolean signApp) {
		this.signApp = signApp;
		return this;
	}

	public Integer getMonthCommunicateNum() {
		return monthCommunicateNum;
	}

	public StudentWrapper setMonthCommunicateNum(Integer monthCommunicateNum) {
		this.monthCommunicateNum = monthCommunicateNum;
		return this;
	}

}
