package com.jz.jar.franchise.wrapper;

import java.math.BigDecimal;

import org.apache.commons.lang3.StringUtils;

import com.jz.jooq.franchise.tables.pojos.ActivityWechatUserInfo;

public class OpenUserWrapper {

	private String openId;
	private String name;
	private String pic;

	private BigDecimal money;
	private Integer num;

	public static OpenUserWrapper of(ActivityWechatUserInfo u) {
		if (u == null) {
			return null;
		}
		return new OpenUserWrapper().setOpenId(u.getOpenid()).setName(u.getNickname())
				.setPic(u.getHeadimgurl(), u.getPic());
	}

	public String getOpenId() {
		return openId;
	}

	public OpenUserWrapper setOpenId(String openId) {
		this.openId = openId;
		return this;
	}

	public String getName() {
		return name;
	}

	public OpenUserWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public OpenUserWrapper setPic(String headimgurl, String pic) {
		if (StringUtils.isEmpty(pic)) {
			this.pic = headimgurl;
		} else {
			this.pic = "http://img.gymchina.com/" + pic;
		}
		return this;
	}

	public BigDecimal getMoney() {
		return money;
	}

	public OpenUserWrapper setMoney(BigDecimal money) {
		this.money = money;
		return this;
	}

	public Integer getNum() {
		return num;
	}

	public OpenUserWrapper setNum(Integer num) {
		this.num = num;
		return this;
	}

}
