/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.service;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.gymchina.bean.tools.PaymentHttpTool;
import com.jz.common.utils.http.ConnectPost;
import com.jz.common.utils.jz.IdTools;
import com.jz.jar.franchise.repository.ActivityCompanyPayRepository;
import com.jz.jooq.franchise.tables.records.ActivityCompanyPayRecord;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ActivityCompnayPayService {
    private Logger logger = LoggerFactory.getLogger(ActivityCompnayPayService.class);
    @Autowired
    private ActivityCompanyPayRepository activityCompanyPayRepository;

    public void companyPay(String jzUrl, String paySignKey, String activityId, String openId, String type, double money, String otherInfo, String remark) {
        Preconditions.checkArgument((money > 0.0 && money <= 100.0 ? 1 : 0) != 0, (Object)"money>0 && money<=100");
        this.logger.warn("activityId:" + activityId + " openId:" + openId + " type:" + type + " money:" + money);
        try {
            ActivityCompanyPayRecord record = new ActivityCompanyPayRecord();
            String orderId = IdTools.encode((String)(activityId + openId));
            record.setOrderId(orderId);
            record.setActivityId(activityId);
            record.setOpenId(openId);
            record.setType(type);
            record.setMoney(new BigDecimal(money));
            record.setOtherInfo(otherInfo);
            record.setRemark(remark);
            record.setStatus(Integer.valueOf(0));
            record.setCreated(Long.valueOf(System.currentTimeMillis()));
            this.activityCompanyPayRepository.createCompanyPay(record);
            int amount = (int)Math.round(money * 100.0);
            HashMap params = Maps.newHashMap();
            params.put("orderId", orderId);
            params.put("openId", openId);
            params.put("amount", String.valueOf(amount));
            params.put("remark", remark);
            params.put("type", "wechat_js");
            String sign = PaymentHttpTool.getGymchinaPayParamSign((Map)params, (String)paySignKey);
            params.put("sign", sign);
            String url = jzUrl + "/pay/trade/companyPay";
            String resp = ConnectPost.send((String)url, (Map)params, (String)"utf8");
            this.logger.warn(resp);
            Map map = (Map)JSON.parseObject((String)resp, Map.class);
            boolean success = MapUtils.getBooleanValue((Map)map, (Object)"success", (boolean)false);
            String paymentNo = MapUtils.getString((Map)map, (Object)"data");
            int nextStatus = success ? 1 : 2;
            this.activityCompanyPayRepository.finishCompanyPay(orderId, nextStatus, paymentNo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public int cntByActOpenType(String activityId, String openId, String type) {
        return this.activityCompanyPayRepository.cntByActOpenType(activityId, openId, type);
    }

    public double getUserTotalMoney(String activityId, String openId) {
        return this.activityCompanyPayRepository.getUserTotalMoney(activityId, openId);
    }
}

