/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityRedpackRecom;
import com.jz.jooq.franchise.tables.ActivityTemplate;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackDetail;
import com.jz.jooq.franchise.tables.pojos.ActivityRedpackRank;
import com.jz.jooq.franchise.tables.pojos.ActivityTemplateRedpack;
import java.math.BigDecimal;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityRedpackRepository
extends FranchiseBaseRepository {
    private static final com.jz.jooq.franchise.tables.ActivityTemplateRedpack TR = Tables.ACTIVITY_TEMPLATE_REDPACK;
    private static final ActivityRedpackRecom RRM = Tables.ACTIVITY_REDPACK_RECOM;
    private static final com.jz.jooq.franchise.tables.ActivityRedpackDetail RDE = Tables.ACTIVITY_REDPACK_DETAIL;
    private static final com.jz.jooq.franchise.tables.ActivityRedpackRank RRK = Tables.ACTIVITY_REDPACK_RANK;
    private static final ActivityTemplate AT = Tables.ACTIVITY_TEMPLATE;

    public ActivityTemplateRedpack getRedpackSetting(String activityId) {
        return (ActivityTemplateRedpack)this.franchiseCtx.selectFrom((Table)TR).where(new Condition[]{ActivityRedpackRepository.TR.ACTIVITY_ID.eq((Object)activityId)}).fetchAnyInto(ActivityTemplateRedpack.class);
    }

    public String getUpOpenId(String activityId, String downOpenId) {
        return (String)this.franchiseCtx.select((SelectField)ActivityRedpackRepository.RRM.UP_OPEN_ID).from((TableLike)RRM).where(new Condition[]{ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.DOWN_OPEN_ID.eq((Object)downOpenId))}).fetchAnyInto(String.class);
    }

    public boolean isRegDownId(String activityId, String downOpenId) {
        return this.franchiseCtx.fetchExists((Table)RRM, ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.DOWN_OPEN_ID.eq((Object)downOpenId)));
    }

    public int cntDowns(String activityId, String upOpenId) {
        return this.franchiseCtx.fetchCount((Table)RRM, ActivityRedpackRepository.RRM.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRM.UP_OPEN_ID.eq((Object)upOpenId)));
    }

    public void createRecom(String activityId, String downOpenId, String upOpenId) {
        this.franchiseCtx.insertInto((Table)RRM, (Field)ActivityRedpackRepository.RRM.ACTIVITY_ID, (Field)ActivityRedpackRepository.RRM.DOWN_OPEN_ID, (Field)ActivityRedpackRepository.RRM.UP_OPEN_ID, (Field)ActivityRedpackRepository.RRM.CREATED).values((Object)activityId, (Object)downOpenId, (Object)upOpenId, (Object)System.currentTimeMillis()).onDuplicateKeyIgnore().execute();
    }

    public void createDetail(String activityId, String upOpenId, String type, String downOpenId, BigDecimal money) {
        this.franchiseCtx.insertInto((Table)RDE, (Field)ActivityRedpackRepository.RDE.ACTIVITY_ID, (Field)ActivityRedpackRepository.RDE.UP_OPEN_ID, (Field)ActivityRedpackRepository.RDE.TYPE, (Field)ActivityRedpackRepository.RDE.DOWN_OPEN_ID, (Field)ActivityRedpackRepository.RDE.MONEY, (Field)ActivityRedpackRepository.RDE.CREATED).values((Object)activityId, (Object)upOpenId, (Object)type, (Object)downOpenId, (Object)money, (Object)System.currentTimeMillis()).execute();
    }

    public void increRank(String activityId, String type, String openId, int num) {
        this.franchiseCtx.insertInto((Table)RRK, (Field)ActivityRedpackRepository.RRK.ACTIVITY_ID, (Field)ActivityRedpackRepository.RRK.TYPE, (Field)ActivityRedpackRepository.RRK.OPEN_ID, (Field)ActivityRedpackRepository.RRK.NUM).values((Object)activityId, (Object)type, (Object)openId, (Object)num).onDuplicateKeyUpdate().set((Field)ActivityRedpackRepository.RRK.NUM, ActivityRedpackRepository.RRK.NUM.add((Number)num)).execute();
    }

    public void increTotalSignNum(String activityId, int num) {
        this.franchiseCtx.update((Table)AT).set((Field)ActivityRedpackRepository.AT.TOTAL_SIGN_NUM, DSL.isnull((Field)ActivityRedpackRepository.AT.TOTAL_SIGN_NUM, (Object)0).add((Number)num)).where(new Condition[]{ActivityRedpackRepository.AT.ACTIVITY_ID.eq((Object)activityId)}).execute();
    }

    public int cntDetailPage(String activityId, String upOpenId, String type) {
        return this.franchiseCtx.fetchCount((Table)RDE, ActivityRedpackRepository.RDE.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RDE.UP_OPEN_ID.eq((Object)upOpenId)).and(ActivityRedpackRepository.RDE.TYPE.eq((Object)type)));
    }

    public List<ActivityRedpackDetail> getDetailPage(String activityId, String upOpenId, String type, int start, int size) {
        return this.franchiseCtx.selectFrom((Table)RDE).where(new Condition[]{ActivityRedpackRepository.RDE.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RDE.UP_OPEN_ID.eq((Object)upOpenId)).and(ActivityRedpackRepository.RDE.TYPE.eq((Object)type))}).orderBy(ActivityRedpackRepository.RDE.ID.desc()).limit(start, size).fetchInto(ActivityRedpackDetail.class);
    }

    public List<ActivityRedpackRank> getRank(String activityId, String type, int size) {
        return this.franchiseCtx.selectFrom((Table)RRK).where(new Condition[]{ActivityRedpackRepository.RRK.ACTIVITY_ID.eq((Object)activityId).and(ActivityRedpackRepository.RRK.TYPE.eq((Object)type))}).orderBy(ActivityRedpackRepository.RRK.NUM.desc()).limit(size).fetchInto(ActivityRedpackRank.class);
    }
}

