package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;

import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityCompanyPay;
import com.jz.jooq.franchise.tables.records.ActivityCompanyPayRecord;

@Lazy
@Repository
public class ActivityCompanyPayRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityCompanyPay ACP = Tables.ACTIVITY_COMPANY_PAY;

	public void createCompanyPay(ActivityCompanyPayRecord record) {
		franchiseCtx.batchInsert(record).execute();
	}

	public ActivityCompanyPay getCompanyPayByOrderId(String orderId) {
		return franchiseCtx.selectFrom(ACP).where(ACP.ORDER_ID.eq(orderId)).fetchAnyInto(ActivityCompanyPay.class);
	}

	public int cntByActOpenType(String activityId, String openId, String type) {
		return franchiseCtx.fetchCount(ACP,
				ACP.ACTIVITY_ID.eq(activityId).and(ACP.OPEN_ID.eq(openId)).and(ACP.TYPE.eq(type)));
	}

	public void finishCompanyPay(String orderId, int status, String paymentNo) {
		franchiseCtx.update(ACP).set(ACP.STATUS, status).set(ACP.PAYMENT_NO, paymentNo).where(ACP.ORDER_ID.eq(orderId))
				.execute();
	}

	public List<ActivityCompanyPay> getByActOpenTypes(String activityId, String openId, Collection<String> types) {
		return franchiseCtx.select(ACP.TYPE, ACP.MONEY, ACP.REMARK, ACP.STATUS, ACP.CREATED).from(ACP)
				.where(ACP.ACTIVITY_ID.eq(activityId).and(ACP.OPEN_ID.eq(openId)).and(ACP.TYPE.in(types)))
				.fetchInto(ActivityCompanyPay.class);
	}

	public double getUserTotalMoney(String activityId, String openId) {
		Double rs = franchiseCtx.select(DSL.sum(ACP.MONEY)).from(ACP)
				.where(ACP.ACTIVITY_ID.eq(activityId).and(ACP.OPEN_ID.eq(openId))).fetchAnyInto(Double.class);
		return rs != null ? rs : 0;
	}
}
