package com.jz.jar.franchise.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ContractCompanyRepository;
import com.jz.jooq.franchise.tables.pojos.ContractCompany;
import com.jz.jooq.franchise.tables.records.ContractCompanyRecord;

@Lazy
@Service
public class ContractCompanyService {

	@Autowired
	private ContractCompanyRepository contractCompanyRepository;

	public ContractCompany getContractCompany(String schoolId, Integer id) {
		return contractCompanyRepository.getContractCompany(schoolId, id);
	}

	public int getMaxCompanyId(String schoolId) {
		return contractCompanyRepository.getMaxCompanyId(schoolId);
	}

	public void createContractCompany(ContractCompanyRecord record) {
		contractCompanyRepository.createContractCompany(record);
	}
}
