package com.jz.jar.franchise.repository;

import java.util.List;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.ActivityHo;

@Lazy
@Repository
public class ActivityHoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.ActivityHo A = Tables.ACTIVITY_HO;
	
	private Condition getWhereCondition(String branchId) {
		return A.BRAND_ID.eq(branchId).and(A.APPLY_STATUS.eq(1)).and(A.PIC.ne(""));
	}
	
	public int countOnlineActivities(String branchId) {
		return franchiseCtx.fetchCount(A, getWhereCondition(branchId));
	}
	
	public List<ActivityHo> findAllOnlineActivities(String branchId, int start, int size) {
		// CASE WHEN `start_time` < unix_timestamp(now())*1000 and `end_time` > unix_timestamp(now())*1000 THEN 0
		// WHEN `start_time` > unix_timestamp(now())*1000 THEN 1 else 2 end
		long timeMillis = System.currentTimeMillis();
		Field<Integer> orderField = DSL.choose()
				.when(A.START_TIME.le(timeMillis).and(A.END_TIME.ge(timeMillis)), DSL.zero())
				.when(A.START_TIME.gt(timeMillis), DSL.one()).otherwise(DSL.two()).as("COT");
		return franchiseCtx.select(A.NAME, A.START_TIME, A.END_TIME, A.DESCRIPTION, A.PIC, A.DISPLAY_URL, orderField)
				.from(A).where(getWhereCondition(branchId)).orderBy(orderField.asc(), A.START_TIME.asc())
				.limit(start, size).fetchInto(ActivityHo.class);
	}

}
