package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.Classroom;
import com.jz.jooq.franchise.tables.records.ClassroomRecord;

@Lazy
@Repository
public class ClassroomRepository extends FranchiseBaseRepository implements FranchiseConditionRepository<ClassroomRecord> {

	private static final com.jz.jooq.franchise.tables.Classroom CR = Tables.CLASSROOM;

	public List<Classroom> findClassrooms(Map<String, Collection<Integer>> school2RoomId) {
		return franchiseCtx.select(CR.SCHOOL_ID, CR.CLASSROOM_ID, CR.NAME).from(CR)
				.where(getOrWhereCondition(CR.SCHOOL_ID, CR.CLASSROOM_ID, school2RoomId)).fetchInto(Classroom.class);
	}
}
