package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.StudentInfoRepository;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;

/**
 * @Title StudentInfoService
 * @Package com.jz.jar.franchise.service
 * @author tangjunfeng
 * @date 2018年8月3日 下午3:24:23
 * @version V1.0
 */
@Lazy
@Service
public class StudentInfoService {

	@Autowired
	private StudentInfoRepository studentInfoRepository;

	public String getStudentBirthday(String suid) {
		return studentInfoRepository.getStudentBirthday(suid);
	}

	public void refreshStudent(String puid, String suid, String cnName, String enName, String sex, String birthday,
			String avatar, String pinyin, String pinyingSimple) {
		studentInfoRepository.refreshStudent(puid, suid, cnName, enName, sex, birthday, avatar, pinyin, pinyingSimple);
	}

	public List<StudentInfo> getStudents(String puid) {
		return studentInfoRepository.getStudents(puid);
	}

	public StudentInfo getStudent(String suid) {
		return studentInfoRepository.getStudent(suid);
	}

	public StudentInfo getSimpleStudentInfo(String suid) {
		return studentInfoRepository.getSimpleStudentInfo(suid);
	}

	public List<StudentInfo> getSimpleStudentInfo(Collection<String> puids) {
		return studentInfoRepository.getSimpleStudentInfo(puids);
	}

	public List<StudentInfo> getSimpleStudentInfoForSuid(Collection<String> suids) {
		return studentInfoRepository.getSimpleStudentInfoForSuid(suids);
	}

	public int getStudentTotalCnt() {
		return studentInfoRepository.getStudentTotalCnt();
	}

	public boolean existCurrentStudent(String puid, String suid) {
		return studentInfoRepository.existCurrentStudent(puid, suid);
	}

	public Map<String, String> getStudentName(String puid) {
		return studentInfoRepository.getStudentName(puid);
	}

	public boolean existStudentName(String puid, String name) {
		return studentInfoRepository.existStudentName(puid, name);
	}

	public StudentInfo getStudentByPuidName(String puid, String name) {
		return studentInfoRepository.getStudentByPuidName(puid, name);
	}

	public void updateStudentStatus(String uid, String suid, int status) {
		studentInfoRepository.updateStudentStatus(uid, suid, status);
	}
}
