package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseManageRepository;
import com.jz.jar.franchise.repository.StudentSchoolRepository;
import com.jz.jooq.franchise.tables.pojos.StudentSchool;

@Lazy
@Service
public class StudentSchoolService {

	@Autowired
	private StudentSchoolRepository studentSchoolRepository;
	@Autowired
	private FranchiseManageRepository manageRepository;

	public boolean isContainsSchool(String suid) {
		return studentSchoolRepository.isContainsSchool(suid);
	}

	public List<String> getContainsSchool(Collection<String> suidArray) {
		return studentSchoolRepository.getContainsSchool(suidArray);
	}

	public Long getFirstContractTime(String suid, String schoolId) {
		return studentSchoolRepository.getFirstContractTime(suid, schoolId);
	}

	public StudentSchool getStopTime(String suid, Collection<String> schoolIds) {
		return studentSchoolRepository.getStopTime(suid, schoolIds);
	}

	public List<String> getFreeOnlineStudySchoolIds(String suid) {
		List<String> readingSchoolIds = studentSchoolRepository.getReadingSchoolIds(suid);
		if (ArrayMapTools.isEmpty(readingSchoolIds)) {
			return null;
		}
		return manageRepository.filterOnlineFreeStudySchools(readingSchoolIds);
	}
}
