package com.jz.jar.franchise.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseTomatoOsRepository;
import com.jz.jar.franchise.repository.CourseTomatoPlanRepository;
import com.jz.jar.franchise.wrapper.OnlineLessonWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlan;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlanOs;
import com.jz.jooq.franchise.tables.pojos.Lesson;

@Lazy
@Service
public class CourseTomatoService {

	@Autowired
	private CourseTomatoPlanRepository courseTomatoPlanRepository;
	@Autowired
	private CourseTomatoOsRepository courseTomatoOsRepository;

	public Map<String, String> mutiCalSchoolSimplePlans(String brandId, List<Lesson> lessons) {
		if (ArrayMapTools.isEmpty(lessons)) {
			return null;
		}
		// 处理基本的信息
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Map<Long, String> startTime2MondayMap = Maps.newHashMap(); // 为了后面效率
		Map<Integer, Set<String>> courseId2MondaysMap = Maps.newHashMap();

		Set<String> auditionIds = Sets.newHashSet();
		Set<String> schoolIds = Sets.newHashSet();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				auditionIds.add(l.getContent());
				schoolIds.add(l.getSchoolId());
			} else {
				long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
				String monday = df.format(this.getMondayOfThisWeek(startTime));
				if (courseId2MondaysMap.containsKey(courseId)) {
					courseId2MondaysMap.get(courseId).add(monday);
				} else {
					courseId2MondaysMap.put(courseId, Sets.newHashSet(monday));
				}
				startTime2MondayMap.put(startTime, monday);
			}
		}

		Map<String, String> courseIdMonday2NameMap = null; // 总部
		if (ArrayMapTools.isNotEmpty(courseId2MondaysMap)) {
			// 总部计划
			courseIdMonday2NameMap = Maps.newHashMap();
			List<CourseTomatoPlan> hoPlans = courseTomatoPlanRepository.getSimplePlansByCourseId2MondayMap(brandId,
					courseId2MondaysMap);
			for (CourseTomatoPlan p : hoPlans) {
				String key = p.getCourseId() + "$" + p.getMonday();
				courseIdMonday2NameMap.put(key, p.getName());
			}
		}

		// 试听课逻辑
		Map<String, String> auditionMap = null;
		if (ArrayMapTools.isNotEmpty(auditionIds)) {
			auditionMap = courseTomatoPlanRepository.mutiGetAuditionMap(brandId, schoolIds, auditionIds);
		}

		// 做最后lessonId->planName的封装
		Map<String, String> rsMap = Maps.newHashMap();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				if (auditionMap.containsKey(l.getContent())) {
					rsMap.put(l.getLessonId(), auditionMap.get(l.getContent()));
				}
			} else {
				if (courseIdMonday2NameMap != null) { // 走到这里，这里一定不会为空
					long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
					String monday = startTime2MondayMap.get(startTime); // 这里不会为空，因为上面处理过
					String hoKey = l.getCourseId() + "$" + monday;
					if (courseIdMonday2NameMap.containsKey(hoKey)) {
						rsMap.put(l.getLessonId(), courseIdMonday2NameMap.get(hoKey));
					}
				}
			}
		}
		return rsMap;
	}

	public Map<String, Pair<String, OnlineLessonWrapper>> mutiCalPlanAndOnlineVideos(String brandId,
			List<Lesson> lessons) {
		if (ArrayMapTools.isEmpty(lessons)) {
			return null;
		}
		// 处理基本的信息
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Map<Long, String> startTime2MondayMap = Maps.newHashMap(); // 为了后面效率
		Map<Integer, Set<String>> courseId2MondaysMap = Maps.newHashMap();

		Set<String> auditionIds = Sets.newHashSet();
		Set<String> schoolIds = Sets.newHashSet();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				auditionIds.add(l.getContent());
				schoolIds.add(l.getSchoolId());
			} else {
				long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
				String monday = df.format(this.getMondayOfThisWeek(startTime));
				if (courseId2MondaysMap.containsKey(courseId)) {
					courseId2MondaysMap.get(courseId).add(monday);
				} else {
					courseId2MondaysMap.put(courseId, Sets.newHashSet(monday));
				}
				startTime2MondayMap.put(startTime, monday);
			}
		}

		Map<String, CourseTomatoPlan> courseIdMonday2PlanMap = null;
		Map<String, OnlineLessonWrapper> planId2OnlineLessonMap = null;
		if (ArrayMapTools.isNotEmpty(courseId2MondaysMap)) {
			// 总部计划
			courseIdMonday2PlanMap = Maps.newHashMap();
			List<CourseTomatoPlan> hoPlans = courseTomatoPlanRepository.getSimplePlansByCourseId2MondayMap(brandId,
					courseId2MondaysMap);
			List<String> planIds = Lists.newArrayList();
			for (CourseTomatoPlan p : hoPlans) {
				String key = p.getCourseId() + "$" + p.getMonday();
				courseIdMonday2PlanMap.put(key, p);
				planIds.add(p.getId());
			}
			List<CourseTomatoPlanOs> oss = courseTomatoOsRepository.mutiGetOsByPlanIds(planIds);
			if (ArrayMapTools.isNotEmpty(oss)) {
				planId2OnlineLessonMap = Maps.newHashMap();
				for (CourseTomatoPlanOs os : oss) {
					planId2OnlineLessonMap.put(os.getPlanId(), OnlineLessonWrapper.of(os, 1)); // 需要提交作业
				}
			}
		}

		// 试听课逻辑
		Map<String, String> auditionMap = null;
		if (ArrayMapTools.isNotEmpty(auditionIds)) {
			auditionMap = courseTomatoPlanRepository.mutiGetAuditionMap(brandId, schoolIds, auditionIds);
		}

		// 做最后lessonId->planName的封装
		Map<String, Pair<String, OnlineLessonWrapper>> rsMap = Maps.newHashMap();
		for (Lesson l : lessons) {
			int courseId = l.getCourseId();
			if (courseId < 0) {
				if (auditionMap.containsKey(l.getContent())) {
					rsMap.put(l.getLessonId(), Pair.of(auditionMap.get(l.getContent()), null));
				}
			} else {
				if (courseIdMonday2PlanMap != null) { // 走到这里，这里一定不会为空
					long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
					String monday = startTime2MondayMap.get(startTime); // 这里不会为空，因为上面处理过
					String hoKey = l.getCourseId() + "$" + monday;
					CourseTomatoPlan plan = courseIdMonday2PlanMap.get(hoKey);
					if (plan != null) {
						OnlineLessonWrapper video = planId2OnlineLessonMap != null ? planId2OnlineLessonMap.get(plan
								.getId()) : null;
						rsMap.put(l.getLessonId(), Pair.of(plan.getName(), video));
					}
				}
			}
		}
		return rsMap;
	}

	public String calSchoolSimplePlan(String brandId, Lesson l) {
		if (l == null) {
			return null;
		}
		String schoolId = l.getSchoolId();
		int courseId = l.getCourseId();
		if (courseId < 0) {
			String auditionId = l.getContent();
			return courseTomatoPlanRepository.getAuditionName(brandId, schoolId, auditionId);
		}

		// 处理基本的信息
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		long startTime = l.getOriginStartTime() != null ? l.getOriginStartTime() : l.getStartTime();
		String monday = df.format(this.getMondayOfThisWeek(startTime));

		// 总部计划
		return courseTomatoPlanRepository.getHoPlanName(brandId, courseId, monday);
	}

	private Date getMondayOfThisWeek(long time) {
		Calendar c = Calendar.getInstance();
		c.setTimeInMillis(time);
		if (c.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
			c.add(Calendar.DATE, -1);
		}
		c.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
		c.set(Calendar.HOUR_OF_DAY, 0);
		c.set(Calendar.MINUTE, 0);
		c.set(Calendar.SECOND, 0);
		c.set(Calendar.MILLISECOND, 0);
		return c.getTime();
	}

	public Map<Integer, String> getCourseTomatoNameForIds(String brandId, Collection<Integer> courseIds) {
		return courseTomatoPlanRepository.getCourseTomatoNameForIds(brandId, courseIds);
	}

	public String getCourseTomatoNameForId(String brandId, Integer courseId) {
		return courseTomatoPlanRepository.getCourseTomatoNameForId(brandId, courseId);
	}

	public Map<String, String> mutiGetPlanMap(String brandId, List<String> planIds) {
		return courseTomatoPlanRepository.mutiGetPlanMap(brandId, planIds);
	}
}
