/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.StudentInfo;
import com.jz.jooq.franchise.tables.records.StudentInfoRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentInfoRepository
extends FranchiseBaseRepository {
    private static final StudentInfo SI = Tables.STUDENT_INFO;

    public String getStudentBirthday(String suid) {
        return (String)this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.BIRTHDAY).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid)}).fetchAnyInto(String.class);
    }

    public void refreshStudent(String puid, String suid, String cnName, String enName, String sex, String birthday, String avatar, String pinyin, String pinyingSimple) {
        StudentInfoRecord student = new StudentInfoRecord();
        student.setSuid(suid);
        student.setPuid(puid);
        student.setName(cnName);
        student.setNamePy(pinyin);
        student.setNamePySimple(pinyingSimple);
        student.setSex(sex);
        student.setBirthday(birthday);
        student.setEngName(enName);
        student.setAvatar(avatar);
        student.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.franchiseCtx.insertInto((Table)SI).set((Record)student).onDuplicateKeyUpdate().set((Field)StudentInfoRepository.SI.NAME, (Object)cnName).set((Field)StudentInfoRepository.SI.NAME_PY, (Object)pinyin).set((Field)StudentInfoRepository.SI.NAME_PY_SIMPLE, (Object)pinyingSimple).set((Field)StudentInfoRepository.SI.SEX, (Object)sex).set((Field)StudentInfoRepository.SI.BIRTHDAY, (Object)birthday).set((Field)StudentInfoRepository.SI.ENG_NAME, (Object)enName).set((Field)StudentInfoRepository.SI.AVATAR, (Object)avatar).execute();
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentInfo> getStudents(String puid) {
        return this.franchiseCtx.selectFrom((Table)SI).where(new Condition[]{StudentInfoRepository.SI.PUID.eq((Object)puid).and(StudentInfoRepository.SI.STATUS.eq((Object)1))}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentInfo getStudent(String suid) {
        return (com.jz.jooq.franchise.tables.pojos.StudentInfo)this.franchiseCtx.selectFrom((Table)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentInfo getSimpleStudentInfo(String suid) {
        return (com.jz.jooq.franchise.tables.pojos.StudentInfo)this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.CODE, (SelectField)StudentInfoRepository.SI.PUID, (SelectField)StudentInfoRepository.SI.SUID, (SelectField)StudentInfoRepository.SI.NAME, (SelectField)StudentInfoRepository.SI.BIRTHDAY, (SelectField)StudentInfoRepository.SI.AVATAR).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid)}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentInfo> getSimpleStudentInfo(Collection<String> puids) {
        return this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.CODE, (SelectField)StudentInfoRepository.SI.PUID, (SelectField)StudentInfoRepository.SI.SUID, (SelectField)StudentInfoRepository.SI.NAME, (SelectField)StudentInfoRepository.SI.BIRTHDAY, (SelectField)StudentInfoRepository.SI.AVATAR).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.PUID.in(puids).and(StudentInfoRepository.SI.STATUS.eq((Object)1))}).orderBy(StudentInfoRepository.SI.BIRTHDAY.asc()).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentInfo> getSimpleStudentInfoForSuid(Collection<String> suids) {
        return this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.CODE, (SelectField)StudentInfoRepository.SI.SUID, (SelectField)StudentInfoRepository.SI.NAME, (SelectField)StudentInfoRepository.SI.BIRTHDAY, (SelectField)StudentInfoRepository.SI.AVATAR, (SelectField)StudentInfoRepository.SI.SEX).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.in(suids)}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public int getStudentTotalCnt() {
        return this.franchiseCtx.fetchCount((Table)SI);
    }

    public boolean existCurrentStudent(String puid, String suid) {
        return this.franchiseCtx.fetchExists((Table)SI, StudentInfoRepository.SI.PUID.eq((Object)puid).and(StudentInfoRepository.SI.SUID.eq((Object)suid)));
    }

    public Map<String, String> getStudentName(String puid) {
        return this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.SUID, (SelectField)StudentInfoRepository.SI.NAME).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.PUID.eq((Object)puid)}).fetchMap((Field)StudentInfoRepository.SI.SUID, (Field)StudentInfoRepository.SI.NAME);
    }

    public boolean existStudentName(String puid, String name) {
        return this.franchiseCtx.fetchExists((Table)SI, StudentInfoRepository.SI.PUID.eq((Object)puid).and(StudentInfoRepository.SI.NAME.eq((Object)name)));
    }

    public com.jz.jooq.franchise.tables.pojos.StudentInfo getStudentByPuidName(String puid, String name) {
        return (com.jz.jooq.franchise.tables.pojos.StudentInfo)this.franchiseCtx.selectFrom((Table)SI).where(new Condition[]{StudentInfoRepository.SI.PUID.eq((Object)puid).and(StudentInfoRepository.SI.NAME.eq((Object)name))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public void updateStudentStatus(String uid, String suid, int status) {
        this.franchiseCtx.update((Table)SI).set((Field)StudentInfoRepository.SI.STATUS, (Object)status).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid).and(StudentInfoRepository.SI.PUID.eq((Object)uid))}).execute();
    }
}

