/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.repository.FranchiseConditionRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Lesson;
import com.jz.jooq.franchise.tables.records.LessonRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.SortField;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class LessonRepository
extends FranchiseBaseRepository
implements FranchiseConditionRepository<LessonRecord> {
    private static final Lesson LE = Tables.LESSON;

    public List<com.jz.jooq.franchise.tables.pojos.Lesson> findLesson(Map<String, Collection<String>> school2Lessons) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        return this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{condition}).orderBy(LessonRepository.LE.START_TIME.asc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Lesson getLesson(String schoolId, String lessonId) {
        return (com.jz.jooq.franchise.tables.pojos.Lesson)this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{LessonRepository.LE.SCHOOL_ID.eq((Object)schoolId).and(LessonRepository.LE.LESSON_ID.eq((Object)lessonId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    private Condition getWhereCondition(Map<String, Collection<String>> school2Lessons, Long currentTimeMillis) {
        Condition condition = this.getOrWhereCondition(LessonRepository.LE.SCHOOL_ID, LessonRepository.LE.LESSON_ID, school2Lessons);
        if (currentTimeMillis > 0L) {
            condition = condition.and(LessonRepository.LE.START_TIME.ge((Object)currentTimeMillis));
        }
        return condition;
    }

    public List<com.jz.jooq.franchise.tables.pojos.Lesson> findLesson(Map<String, Collection<String>> school2Lessons, boolean asc, Long currentTimeMillis, int start, int size) {
        SortField sortField = asc ? LessonRepository.LE.START_TIME.asc() : LessonRepository.LE.START_TIME.desc();
        return this.franchiseCtx.selectFrom((Table)LE).where(new Condition[]{this.getWhereCondition(school2Lessons, currentTimeMillis)}).orderBy(sortField).limit(start, size).fetchInto(com.jz.jooq.franchise.tables.pojos.Lesson.class);
    }

    public int countLesson(Map<String, Collection<String>> school2Lessons, Long currentTimeMillis) {
        return this.franchiseCtx.fetchCount((Table)LE, this.getWhereCondition(school2Lessons, currentTimeMillis));
    }
}

