/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.ActivityHo;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class ActivityHoRepository
extends FranchiseBaseRepository {
    private static final ActivityHo A = Tables.ACTIVITY_HO;

    private Condition getWhereCondition(String branchId) {
        return ActivityHoRepository.A.BRAND_ID.eq((Object)branchId).and(ActivityHoRepository.A.APPLY_STATUS.eq((Object)1)).and(ActivityHoRepository.A.PIC.ne((Object)""));
    }

    public int countOnlineActivities(String branchId) {
        return this.franchiseCtx.fetchCount((Table)A, this.getWhereCondition(branchId));
    }

    public List<com.jz.jooq.franchise.tables.pojos.ActivityHo> findAllOnlineActivities(String branchId, int start, int size) {
        long timeMillis = System.currentTimeMillis();
        Field orderField = DSL.choose().when(ActivityHoRepository.A.START_TIME.le((Object)timeMillis).and(ActivityHoRepository.A.END_TIME.ge((Object)timeMillis)), DSL.zero()).when(ActivityHoRepository.A.START_TIME.gt((Object)timeMillis), DSL.one()).otherwise(DSL.two()).as("COT");
        return this.franchiseCtx.select((SelectField)ActivityHoRepository.A.NAME, (SelectField)ActivityHoRepository.A.START_TIME, (SelectField)ActivityHoRepository.A.END_TIME, (SelectField)ActivityHoRepository.A.DESCRIPTION, (SelectField)ActivityHoRepository.A.PIC, (SelectField)ActivityHoRepository.A.DISPLAY_URL, (SelectField)orderField).from((TableLike)A).where(new Condition[]{this.getWhereCondition(branchId)}).orderBy(orderField.asc(), ActivityHoRepository.A.START_TIME.asc()).limit(start, size).fetchInto(com.jz.jooq.franchise.tables.pojos.ActivityHo.class);
    }
}

