/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.Recruit;
import com.jz.jooq.franchise.tables.RecruitSchool;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class RecruitRepository
extends FranchiseBaseRepository {
    private static final Recruit RT = Tables.RECRUIT;
    private static final RecruitSchool RS = Tables.RECRUIT_SCHOOL;

    private Condition getCondition(String school, String prov, String city) {
        Condition condition = RecruitRepository.RS.SCHOOL_ID.eq((Object)school).and(RecruitRepository.RS.CREATE_TIME.gt((Object)0L)).and(RecruitRepository.RS.STATUS.eq((Object)1));
        if (StringTools.isNotEmptyAndBlank((String)prov)) {
            condition = condition.and(RecruitRepository.RS.PROV.eq((Object)prov));
            if (StringTools.isNotEmptyAndBlank((String)city)) {
                condition = condition.and(RecruitRepository.RS.CITY.eq((Object)city));
            }
        }
        return condition;
    }

    public int cntRecruits(String school, String prov, String city) {
        return this.franchiseCtx.fetchCount((Table)RS, this.getCondition(school, prov, city));
    }

    public List<String> getRecruitIds(String school, String prov, String city, int start, int size) {
        return this.franchiseCtx.select((SelectField)RecruitRepository.RS.RID).from((TableLike)RS).where(new Condition[]{this.getCondition(school, prov, city)}).orderBy(RecruitRepository.RS.CREATE_TIME.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<com.jz.jooq.franchise.tables.pojos.Recruit> getListRecruitInfo(List<String> rids) {
        return this.franchiseCtx.select((SelectField)RecruitRepository.RT.RID, (SelectField)RecruitRepository.RT.POSITION, (SelectField)RecruitRepository.RT.SALARY_RANGE, (SelectField)RecruitRepository.RT.PROV, (SelectField)RecruitRepository.RT.CITY, (SelectField)RecruitRepository.RT.NUM, (SelectField)RecruitRepository.RT.DEGREE).from((TableLike)RT).where(new Condition[]{RecruitRepository.RT.RID.in(rids)}).orderBy(RecruitRepository.RT.CREATE_TIME.desc()).fetchInto(com.jz.jooq.franchise.tables.pojos.Recruit.class);
    }

    public com.jz.jooq.franchise.tables.pojos.Recruit getRecruitInfo(String rid) {
        return (com.jz.jooq.franchise.tables.pojos.Recruit)ArrayMapTools.getFirst((Collection)this.franchiseCtx.selectFrom((Table)RT).where(new Condition[]{RecruitRepository.RT.RID.eq((Object)rid)}).fetchInto(com.jz.jooq.franchise.tables.pojos.Recruit.class));
    }
}

