package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.tuple.Triple;
import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlan;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoSchoolPlan;

@Lazy
@Repository
public class CourseTomatoPlanRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.CourseTomato CT = Tables.COURSE_TOMATO;
	private static final com.jz.jooq.franchise.tables.CourseTomatoPlan CTP = Tables.COURSE_TOMATO_PLAN;
	private static final com.jz.jooq.franchise.tables.CourseTomatoAudition CTA = Tables.COURSE_TOMATO_AUDITION;
	private static final com.jz.jooq.franchise.tables.CourseTomatoSchoolPlan CTSP = Tables.COURSE_TOMATO_SCHOOL_PLAN;

	public Map<Integer, String> getCourseTomatoNameForIds(String brandId, Collection<Integer> courseIds) {
		return franchiseCtx.select(CT.COURSE_ID, CT.COURSE_NAME).from(CT)
				.where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.in(courseIds))).fetchMap(CT.COURSE_ID, CT.COURSE_NAME);
	}
	
	public String getCourseTomatoNameForId(String brandId, Integer courseId) {
		return franchiseCtx.select(CT.COURSE_NAME).from(CT)
				.where(CT.BRAND_ID.eq(brandId).and(CT.COURSE_ID.eq(courseId))).fetchAnyInto(String.class);
	}
	
	public List<CourseTomatoPlan> getSimplePlansByCourseId2MondayMap(String brandId,
			Map<Integer, Set<String>> courseId2MondaysMap) {
		List<Condition> conditions = Lists.newArrayList();
		courseId2MondaysMap.forEach((courseId, mondaySet) -> {
			conditions.add(CTP.COURSE_ID.eq(courseId).and(CTP.MONDAY.in(mondaySet)));
		});
		return franchiseCtx.select(CTP.ID, CTP.COURSE_ID, CTP.MONDAY, CTP.NAME).from(CTP)
				.where(CTP.BRAND_ID.eq(brandId).and(DSL.or(conditions))).fetchInto(CourseTomatoPlan.class);
	}

	public String getHoPlanName(String brandId, Integer courseId, String monday) {
		return franchiseCtx.select(CTP.NAME).from(CTP)
				.where(CTP.BRAND_ID.eq(brandId).and(CTP.COURSE_ID.eq(courseId)).and(CTP.MONDAY.eq(monday)))
				.fetchAnyInto(String.class);
	}

	public Map<String, String> mutiGetAuditionMap(String brandId, Set<String> schoolIds, Set<String> auditionIds) {
		List<String> schoolBrandIds = Lists.newArrayList(brandId);
		schoolBrandIds.addAll(schoolIds);
		return franchiseCtx.select(CTA.ID, CTA.NAME).from(CTA)
				.where(CTA.SCHOOL_BRAND_ID.in(schoolBrandIds).and(CTA.ID.in(auditionIds))).fetchMap(CTA.ID, CTA.NAME);
	}

	public String getAuditionName(String brandId, String schoolId, String auditionId) {
		return franchiseCtx.select(CTA.NAME).from(CTA)
				.where(CTA.SCHOOL_BRAND_ID.in(brandId, schoolId).and(CTA.ID.eq(auditionId))).fetchAnyInto(String.class);
	}

	public List<CourseTomatoSchoolPlan> getSimplePlansByTriple(
			List<Triple<String, Integer, String>> schoolIdCourseIdMondayList) {
		List<Condition> conditions = Lists.newArrayList();
		for (Triple<String, Integer, String> t : schoolIdCourseIdMondayList) {
			conditions.add(CTSP.SCHOOL_ID.eq(t.getLeft()).and(CTSP.MONDAY.eq(t.getRight()))
					.and(CTSP.COURSE_ID.eq(t.getMiddle())));
		}
		return franchiseCtx.selectFrom(CTSP).where(DSL.or(conditions)).fetchInto(CourseTomatoSchoolPlan.class);
	}

	public CourseTomatoSchoolPlan getSchoolPlan(String schoolId, Integer courseId, String monday) {
		return franchiseCtx.selectFrom(CTSP)
				.where(CTSP.SCHOOL_ID.eq(schoolId).and(CTSP.MONDAY.eq(monday)).and(CTSP.COURSE_ID.eq(courseId)))
				.fetchAnyInto(CourseTomatoSchoolPlan.class);
	}

	public Map<String, String> mutiGetPlanMap(String brandId, List<String> planIds) {
		return franchiseCtx.select(CTP.ID, CTP.NAME).from(CTP).where(CTP.BRAND_ID.eq(brandId).and(CTP.ID.in(planIds)))
				.fetchMap(CTP.ID, CTP.NAME);
	}

	public String getPlanName(String brandId, String planId) {
		return franchiseCtx.select(CTP.NAME).from(CTP).where(CTP.BRAND_ID.eq(brandId).and(CTP.ID.eq(planId)))
				.fetchAnyInto(String.class);
	}
}
