package com.jz.jar.franchise.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.jooq.Condition;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.LessonStudentFeedBack;
import com.jz.jooq.franchise.tables.records.LessonStudentFeedBackRecord;

@Lazy
@Repository
public class LessonStudentFeedbackRepository extends FranchiseBaseRepository
		implements FranchiseConditionRepository<LessonStudentFeedBackRecord> {

	private static final com.jz.jooq.franchise.tables.LessonStudentFeedBack LSFB = Tables.LESSON_STUDENT_FEED_BACK;

	public List<LessonStudentFeedBack> findFeedback(String suid, Map<String, Collection<String>> school2LessonId) {
		Condition condition = getOrWhereCondition(LSFB.SCHOOL_ID, LSFB.LESSON_ID, school2LessonId)
				.and(LSFB.SUID.eq(suid));
		condition = condition.and(LSFB.STU_READ.eq(1)); // 已经评价
		return franchiseCtx.selectFrom(LSFB).where(condition).fetchInto(LessonStudentFeedBack.class);
	}

}
