/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jar.franchise.repository.FranchiseConditionRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.StudentSchoolContract;
import com.jz.jooq.franchise.tables.StudentSchoolExtra;
import com.jz.jooq.franchise.tables.records.StudentSchoolContractRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentSchoolContractRepository
extends FranchiseBaseRepository
implements FranchiseConditionRepository<StudentSchoolContractRecord> {
    private static final StudentSchoolContract SSC = Tables.STUDENT_SCHOOL_CONTRACT;
    private static final StudentSchoolExtra SSE = Tables.STUDENT_SCHOOL_EXTRA;

    public Pair<Integer, Integer> getLessionCount(String suid) {
        List maps = this.franchiseCtx.select((SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.TOTAL_OFFICAL_LESSON).as("total"), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON).as("consume")).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(StudentSchoolContractRepository.SSC.STATUS.ne((Object)-1))}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)maps)) {
            return Pair.of((Object)0, (Object)0);
        }
        Map has = (Map)maps.get(0);
        if (ArrayMapTools.isEmpty((Map)has) || !ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"total", "consume"})) {
            return Pair.of((Object)0, (Object)0);
        }
        return Pair.of((Object)ArrayMapTools.getInteger((Map)has, (Object)"total", (Integer)0), (Object)ArrayMapTools.getInteger((Map)has, (Object)"consume", (Integer)0));
    }

    public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids) {
        List fetchMaps = this.franchiseCtx.select((SelectField)StudentSchoolContractRepository.SSC.SUID, (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.TOTAL_OFFICAL_LESSON).as("total"), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON).as("consume")).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.in(suids).and(StudentSchoolContractRepository.SSC.STATUS.ne((Object)-1))}).fetchMaps();
        if (ArrayMapTools.isEmpty((Collection)fetchMaps)) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map has : fetchMaps) {
            if (ArrayMapTools.isEmpty((Map)has) || !ArrayMapTools.containsKeys((Map)has, (String[])new String[]{"suid", "total", "consume"})) continue;
            result.put(MapUtils.getString((Map)has, (Object)"suid"), Pair.of((Object)MapUtils.getInteger((Map)has, (Object)"total"), (Object)MapUtils.getInteger((Map)has, (Object)"consume")));
        }
        return result;
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentSchoolContract> getSimpleStudentSchoolContracts(String suid, Map<String, Collection<String>> school2ContractId) {
        Condition condition = this.getOrWhereCondition(StudentSchoolContractRepository.SSC.SCHOOL_ID, StudentSchoolContractRepository.SSC.CONTRACT_ID, school2ContractId);
        condition = StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(condition);
        return this.franchiseCtx.select((SelectField)StudentSchoolContractRepository.SSC.SCHOOL_ID, (SelectField)StudentSchoolContractRepository.SSC.CONTRACT_ID, (SelectField)StudentSchoolContractRepository.SSC.LEAVE_NUM, (SelectField)StudentSchoolContractRepository.SSC.MAX_LEAVE_NUM).from((TableLike)SSC).where(new Condition[]{condition}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentSchoolContract.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentSchoolContract getStudentSchoolContract(String suid, String school, String contractId) {
        return (com.jz.jooq.franchise.tables.pojos.StudentSchoolContract)this.franchiseCtx.selectFrom((Table)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(StudentSchoolContractRepository.SSC.SCHOOL_ID.eq((Object)school)).and(StudentSchoolContractRepository.SSC.CONTRACT_ID.eq((Object)contractId))}).fetchAnyInto(com.jz.jooq.franchise.tables.pojos.StudentSchoolContract.class);
    }

    public void addLeaveNum(String suid, String school, String contractId, int addCnt) {
        this.franchiseCtx.update((Table)SSC).set((Field)StudentSchoolContractRepository.SSC.LEAVE_NUM, StudentSchoolContractRepository.SSC.LEAVE_NUM.add((Number)addCnt)).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(StudentSchoolContractRepository.SSC.SCHOOL_ID.eq((Object)school)).and(StudentSchoolContractRepository.SSC.CONTRACT_ID.eq((Object)contractId))}).execute();
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentSchoolContract> getSSCByContractId(String schoolId, String contractId) {
        return this.franchiseCtx.selectFrom((Table)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SCHOOL_ID.eq((Object)schoolId).and(StudentSchoolContractRepository.SSC.CONTRACT_ID.eq((Object)contractId))}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentSchoolContract.class);
    }

    public List<Map<String, Object>> mutiCalContractConsumes(List<String> contractIds) {
        return this.franchiseCtx.select((SelectField)StudentSchoolContractRepository.SSC.CONTRACT_ID.as("contractId"), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON).as("consumeOfficalLesson"), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.NO_SCHEDULE_OFFICAL_LESSON).as("noScheduleOfficalLesson")).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.CONTRACT_ID.in(contractIds)}).groupBy(new GroupField[]{StudentSchoolContractRepository.SSC.CONTRACT_ID}).fetchMaps();
    }

    public List<String> getIsContinueContract(List<String> contractIds) {
        return this.franchiseCtx.select((SelectField)StudentSchoolContractRepository.SSC.CONTRACT_ID).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.CONTRACT_ID.in(contractIds).and(StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON.lt((Field)StudentSchoolContractRepository.SSC.TOTAL_OFFICAL_LESSON))}).groupBy(new GroupField[]{StudentSchoolContractRepository.SSC.CONTRACT_ID}).fetchInto(String.class);
    }

    public boolean dealRollbackOfficalLesson(String suid, String schoolId, String contractId, int rollbackNum) {
        Preconditions.checkArgument((rollbackNum > 0 ? 1 : 0) != 0, (Object)"scheduleNum>0");
        return this.franchiseCtx.update((Table)SSC).set((Field)StudentSchoolContractRepository.SSC.NO_SCHEDULE_OFFICAL_LESSON, StudentSchoolContractRepository.SSC.NO_SCHEDULE_OFFICAL_LESSON.add((Number)rollbackNum)).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(StudentSchoolContractRepository.SSC.SCHOOL_ID.eq((Object)schoolId)).and(StudentSchoolContractRepository.SSC.CONTRACT_ID.eq((Object)contractId))}).execute() > 0;
    }

    public boolean dealRollbackExtraLesson(String suid, String schoolId, int extraId, int rollbackNum) {
        Preconditions.checkArgument((rollbackNum > 0 ? 1 : 0) != 0, (Object)"rollbackNum>0");
        return this.franchiseCtx.update((Table)SSE).set((Field)StudentSchoolContractRepository.SSE.NO_SCHEDULE, StudentSchoolContractRepository.SSE.NO_SCHEDULE.add((Number)rollbackNum)).where(new Condition[]{StudentSchoolContractRepository.SSE.ID.eq((Object)extraId).and(StudentSchoolContractRepository.SSE.SUID.eq((Object)suid)).and(StudentSchoolContractRepository.SSE.SCHOOL_ID.eq((Object)schoolId))}).execute() > 0;
    }
}

