/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.wrapper;

import com.jz.jar.franchise.util.AgeCalUtil;
import com.jz.jar.franchise.wrapper.StudentContractWrapper;
import com.jz.jar.franchise.wrapper.UserSimpleWrapper;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentSchool;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StudentWrapper {
    private Integer code;
    private String suid;
    private String name;
    private String sex;
    private String birthday;
    private Integer age;
    private String engName;
    private String kg;
    private Integer status;
    private Long stopStartTime;
    private Long stopEndTime;
    private UserSimpleWrapper adviser;
    private UserSimpleWrapper teacher;
    private UserSimpleWrapper teacher2;
    private UserSimpleWrapper mentor;
    private Long firstContractTime;
    private String remark;
    private Integer caseCommNum;
    private Integer stuCommNum;
    private Long lastCommunicateTime;
    private String lastCommunicateRs;
    private String puid;
    private String parentName;
    private String phone;
    private String relation;
    private String address;
    private String district;
    private String otherContact;
    private List<StudentContractWrapper> contracts;
    private Integer totalLessonNum;
    private Integer totalConsumeNum;
    private Integer totalExtraNum;
    private Integer totalExtraConsumeNum;
    private Integer totalLeftNum;

    public static StudentWrapper of(StudentInfo si) {
        return new StudentWrapper().setStudentInfo(si);
    }

    public static StudentWrapper ofBase(StudentInfo si) {
        return new StudentWrapper().setSuid(si.getSuid()).setName(si.getName());
    }

    public static StudentWrapper of(StudentSchool ss) {
        StudentWrapper wrapper = new StudentWrapper().setSuid(ss.getSuid()).setRemark(ss.getRemark());
        if (ss.getStopStartTime() > 0L && ss.getStopEndTime() > 0L) {
            wrapper.setStopStartTime(ss.getStopStartTime()).setStopEndTime(ss.getStopEndTime());
        }
        if (ss.getFirstContractTime() > 0L) {
            wrapper.setFirstContractTime(ss.getFirstContractTime());
        }
        wrapper.setCaseCommNum(ss.getCaseCommNum());
        wrapper.setStuCommNum(ss.getStuCommNum());
        wrapper.setLastCommunicateTime(ss.getLastCommunicateTime());
        return wrapper;
    }

    public StudentWrapper setStudentInfo(StudentInfo si) {
        this.setSuid(si.getSuid()).setCode(si.getCode()).setName(si.getName()).setSex(si.getSex()).setBirthday(si.getBirthday()).setEngName(si.getEngName()).setKg(si.getKg());
        if (StringUtils.isNotEmpty((CharSequence)si.getBirthday())) {
            this.setAge(AgeCalUtil.getAge(si.getBirthday()));
        }
        return this;
    }

    public StudentWrapper setParentInfo(ParentInfo pi) {
        return this.setPuid(pi.getPuid()).setParentName(pi.getName()).setPhone(pi.getPhone()).setRelation(pi.getRelation()).setAddress(pi.getAddress()).setDistrict(pi.getDistrict()).setOtherContact(pi.getOtherContact());
    }

    public String getSuid() {
        return this.suid;
    }

    public StudentWrapper setSuid(String suid) {
        this.suid = suid;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public StudentWrapper setName(String name) {
        this.name = name;
        return this;
    }

    public String getSex() {
        return this.sex;
    }

    public StudentWrapper setSex(String sex) {
        this.sex = sex;
        return this;
    }

    public String getBirthday() {
        return this.birthday;
    }

    public StudentWrapper setBirthday(String birthday) {
        this.birthday = birthday;
        return this;
    }

    public Integer getAge() {
        return this.age;
    }

    public StudentWrapper setAge(Integer age) {
        this.age = age;
        return this;
    }

    public String getEngName() {
        return this.engName;
    }

    public StudentWrapper setEngName(String engName) {
        this.engName = engName;
        return this;
    }

    public Integer getStatus() {
        return this.status;
    }

    public StudentWrapper setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public Long getStopStartTime() {
        return this.stopStartTime;
    }

    public StudentWrapper setStopStartTime(Long stopStartTime) {
        this.stopStartTime = stopStartTime;
        return this;
    }

    public Long getStopEndTime() {
        return this.stopEndTime;
    }

    public StudentWrapper setStopEndTime(Long stopEndTime) {
        this.stopEndTime = stopEndTime;
        return this;
    }

    public UserSimpleWrapper getAdviser() {
        return this.adviser;
    }

    public StudentWrapper setAdviser(UserSimpleWrapper adviser) {
        this.adviser = adviser;
        return this;
    }

    public UserSimpleWrapper getTeacher() {
        return this.teacher;
    }

    public StudentWrapper setTeacher(UserSimpleWrapper teacher) {
        this.teacher = teacher;
        return this;
    }

    public List<StudentContractWrapper> getContracts() {
        return this.contracts;
    }

    public StudentWrapper setContracts(List<StudentContractWrapper> contracts) {
        this.contracts = contracts;
        return this;
    }

    public Long getFirstContractTime() {
        return this.firstContractTime;
    }

    public StudentWrapper setFirstContractTime(Long firstContractTime) {
        this.firstContractTime = firstContractTime;
        return this;
    }

    public String getParentName() {
        return this.parentName;
    }

    public StudentWrapper setParentName(String parentName) {
        this.parentName = parentName;
        return this;
    }

    public String getPhone() {
        return this.phone;
    }

    public StudentWrapper setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getRelation() {
        return this.relation;
    }

    public StudentWrapper setRelation(String relation) {
        this.relation = relation;
        return this;
    }

    public String getRemark() {
        return this.remark;
    }

    public StudentWrapper setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public StudentWrapper setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getPuid() {
        return this.puid;
    }

    public StudentWrapper setPuid(String puid) {
        this.puid = puid;
        return this;
    }

    public String getKg() {
        return this.kg;
    }

    public StudentWrapper setKg(String kg) {
        this.kg = kg;
        return this;
    }

    public String getDistrict() {
        return this.district;
    }

    public StudentWrapper setDistrict(String district) {
        this.district = district;
        return this;
    }

    public UserSimpleWrapper getTeacher2() {
        return this.teacher2;
    }

    public StudentWrapper setTeacher2(UserSimpleWrapper teacher2) {
        this.teacher2 = teacher2;
        return this;
    }

    public Integer getCode() {
        return this.code;
    }

    public StudentWrapper setCode(Integer code) {
        this.code = code;
        return this;
    }

    public Integer getCaseCommNum() {
        return this.caseCommNum;
    }

    public StudentWrapper setCaseCommNum(Integer caseCommNum) {
        this.caseCommNum = caseCommNum;
        return this;
    }

    public Integer getStuCommNum() {
        return this.stuCommNum;
    }

    public StudentWrapper setStuCommNum(Integer stuCommNum) {
        this.stuCommNum = stuCommNum;
        return this;
    }

    public Integer getTotalLessonNum() {
        return this.totalLessonNum;
    }

    public StudentWrapper setTotalLessonNum(Integer totalLessonNum) {
        this.totalLessonNum = totalLessonNum;
        return this;
    }

    public Integer getTotalConsumeNum() {
        return this.totalConsumeNum;
    }

    public StudentWrapper setTotalConsumeNum(Integer totalConsumeNum) {
        this.totalConsumeNum = totalConsumeNum;
        return this;
    }

    public String getOtherContact() {
        return this.otherContact;
    }

    public StudentWrapper setOtherContact(String otherContact) {
        this.otherContact = otherContact;
        return this;
    }

    public UserSimpleWrapper getMentor() {
        return this.mentor;
    }

    public StudentWrapper setMentor(UserSimpleWrapper mentor) {
        this.mentor = mentor;
        return this;
    }

    public Long getLastCommunicateTime() {
        return this.lastCommunicateTime;
    }

    public StudentWrapper setLastCommunicateTime(Long lastCommunicateTime) {
        this.lastCommunicateTime = lastCommunicateTime;
        return this;
    }

    public String getLastCommunicateRs() {
        return this.lastCommunicateRs;
    }

    public StudentWrapper setLastCommunicateRs(String lastCommunicateRs) {
        this.lastCommunicateRs = lastCommunicateRs;
        return this;
    }

    public Integer getTotalExtraNum() {
        return this.totalExtraNum;
    }

    public StudentWrapper setTotalExtraNum(Integer totalExtraNum) {
        this.totalExtraNum = totalExtraNum;
        return this;
    }

    public Integer getTotalExtraConsumeNum() {
        return this.totalExtraConsumeNum;
    }

    public StudentWrapper setTotalExtraConsumeNum(Integer totalExtraConsumeNum) {
        this.totalExtraConsumeNum = totalExtraConsumeNum;
        return this;
    }

    public Integer getTotalLeftNum() {
        return this.totalLeftNum;
    }

    public StudentWrapper setTotalLeftNum(Integer totalLeftNum) {
        if (totalLeftNum != null && totalLeftNum < 0) {
            totalLeftNum = 0;
        }
        this.totalLeftNum = totalLeftNum;
        return this;
    }
}

