/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.google.common.collect.Lists;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.CourseTomato;
import com.jz.jooq.franchise.tables.CourseTomatoAudition;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoPlan;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoSchoolPlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Triple;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class CourseTomatoPlanRepository
extends FranchiseBaseRepository {
    private static final CourseTomato CT = Tables.COURSE_TOMATO;
    private static final com.jz.jooq.franchise.tables.CourseTomatoPlan CTP = Tables.COURSE_TOMATO_PLAN;
    private static final CourseTomatoAudition CTA = Tables.COURSE_TOMATO_AUDITION;
    private static final com.jz.jooq.franchise.tables.CourseTomatoSchoolPlan CTSP = Tables.COURSE_TOMATO_SCHOOL_PLAN;

    public Map<Integer, String> getCourseTomatoNameForIds(String brandId, Collection<Integer> courseIds) {
        return this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CT.COURSE_ID, (SelectField)CourseTomatoPlanRepository.CT.COURSE_NAME).from((TableLike)CT).where(new Condition[]{CourseTomatoPlanRepository.CT.BRAND_ID.eq((Object)brandId).and(CourseTomatoPlanRepository.CT.COURSE_ID.in(courseIds))}).fetchMap((Field)CourseTomatoPlanRepository.CT.COURSE_ID, (Field)CourseTomatoPlanRepository.CT.COURSE_NAME);
    }

    public String getCourseTomatoNameForId(String brandId, Integer courseId) {
        return (String)this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CT.COURSE_NAME).from((TableLike)CT).where(new Condition[]{CourseTomatoPlanRepository.CT.BRAND_ID.eq((Object)brandId).and(CourseTomatoPlanRepository.CT.COURSE_ID.eq((Object)courseId))}).fetchAnyInto(String.class);
    }

    public List<CourseTomatoPlan> getSimplePlansByCourseId2MondayMap(String brandId, Map<Integer, Set<String>> courseId2MondaysMap) {
        ArrayList conditions = Lists.newArrayList();
        courseId2MondaysMap.forEach((courseId, mondaySet) -> conditions.add(CourseTomatoPlanRepository.CTP.COURSE_ID.eq(courseId).and(CourseTomatoPlanRepository.CTP.MONDAY.in((Collection)mondaySet))));
        return this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTP.ID, (SelectField)CourseTomatoPlanRepository.CTP.COURSE_ID, (SelectField)CourseTomatoPlanRepository.CTP.MONDAY, (SelectField)CourseTomatoPlanRepository.CTP.NAME).from((TableLike)CTP).where(new Condition[]{CourseTomatoPlanRepository.CTP.BRAND_ID.eq((Object)brandId).and(DSL.or((Collection)conditions))}).fetchInto(CourseTomatoPlan.class);
    }

    public String getHoPlanName(String brandId, Integer courseId, String monday) {
        return (String)this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTP.NAME).from((TableLike)CTP).where(new Condition[]{CourseTomatoPlanRepository.CTP.BRAND_ID.eq((Object)brandId).and(CourseTomatoPlanRepository.CTP.COURSE_ID.eq((Object)courseId)).and(CourseTomatoPlanRepository.CTP.MONDAY.eq((Object)monday))}).fetchAnyInto(String.class);
    }

    public Map<String, String> mutiGetAuditionMap(String brandId, Set<String> schoolIds, Set<String> auditionIds) {
        ArrayList schoolBrandIds = Lists.newArrayList((Object[])new String[]{brandId});
        schoolBrandIds.addAll(schoolIds);
        return this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTA.ID, (SelectField)CourseTomatoPlanRepository.CTA.NAME).from((TableLike)CTA).where(new Condition[]{CourseTomatoPlanRepository.CTA.SCHOOL_BRAND_ID.in((Collection)schoolBrandIds).and(CourseTomatoPlanRepository.CTA.ID.in(auditionIds))}).fetchMap((Field)CourseTomatoPlanRepository.CTA.ID, (Field)CourseTomatoPlanRepository.CTA.NAME);
    }

    public String getAuditionName(String brandId, String schoolId, String auditionId) {
        return (String)this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTA.NAME).from((TableLike)CTA).where(new Condition[]{CourseTomatoPlanRepository.CTA.SCHOOL_BRAND_ID.in((Object[])new String[]{brandId, schoolId}).and(CourseTomatoPlanRepository.CTA.ID.eq((Object)auditionId))}).fetchAnyInto(String.class);
    }

    public List<CourseTomatoSchoolPlan> getSimplePlansByTriple(List<Triple<String, Integer, String>> schoolIdCourseIdMondayList) {
        ArrayList conditions = Lists.newArrayList();
        for (Triple<String, Integer, String> t : schoolIdCourseIdMondayList) {
            conditions.add(CourseTomatoPlanRepository.CTSP.SCHOOL_ID.eq(t.getLeft()).and(CourseTomatoPlanRepository.CTSP.MONDAY.eq(t.getRight())).and(CourseTomatoPlanRepository.CTSP.COURSE_ID.eq(t.getMiddle())));
        }
        return this.franchiseCtx.selectFrom((Table)CTSP).where(new Condition[]{DSL.or((Collection)conditions)}).fetchInto(CourseTomatoSchoolPlan.class);
    }

    public CourseTomatoSchoolPlan getSchoolPlan(String schoolId, Integer courseId, String monday) {
        return (CourseTomatoSchoolPlan)this.franchiseCtx.selectFrom((Table)CTSP).where(new Condition[]{CourseTomatoPlanRepository.CTSP.SCHOOL_ID.eq((Object)schoolId).and(CourseTomatoPlanRepository.CTSP.MONDAY.eq((Object)monday)).and(CourseTomatoPlanRepository.CTSP.COURSE_ID.eq((Object)courseId))}).fetchAnyInto(CourseTomatoSchoolPlan.class);
    }

    public Map<String, String> mutiGetPlanMap(String brandId, List<String> planIds) {
        return this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTP.ID, (SelectField)CourseTomatoPlanRepository.CTP.NAME).from((TableLike)CTP).where(new Condition[]{CourseTomatoPlanRepository.CTP.BRAND_ID.eq((Object)brandId).and(CourseTomatoPlanRepository.CTP.ID.in(planIds))}).fetchMap((Field)CourseTomatoPlanRepository.CTP.ID, (Field)CourseTomatoPlanRepository.CTP.NAME);
    }

    public String getPlanName(String brandId, String planId) {
        return (String)this.franchiseCtx.select((SelectField)CourseTomatoPlanRepository.CTP.NAME).from((TableLike)CTP).where(new Condition[]{CourseTomatoPlanRepository.CTP.BRAND_ID.eq((Object)brandId).and(CourseTomatoPlanRepository.CTP.ID.eq((Object)planId))}).fetchAnyInto(String.class);
    }
}

