package com.jz.jar.franchise.service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CoursePackRepository;
import com.jz.jar.franchise.wrapper.CoursePackWrapper;
import com.jz.jooq.franchise.tables.pojos.CoursePackSchool;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2;
import com.jz.jooq.franchise.tables.pojos.CoursePackV2City;

@Lazy
@Service
public class CoursePackService {

	@Autowired
	private CoursePackRepository coursePackRepository;

	public List<Integer> getCoursesByPackId(String brandId, String prov, String city, String schoolId,
			String coursePackId) {
		List<Integer> courseIds = coursePackRepository.getHoCourseIds(brandId, coursePackId);
		if (ArrayMapTools.isEmpty(courseIds)) {
			courseIds = coursePackRepository.getSchoolCourseIds(schoolId, coursePackId);
		}
		return courseIds;
	}

	public CoursePackWrapper getCoursePackWrapper(String brandId, String prov, String city, String schoolId,
			String coursePackId) {
		CoursePackV2 hoPack = coursePackRepository.getCoursePackHo(brandId, coursePackId);
		if (hoPack != null) {
			CoursePackV2City price = coursePackRepository.getCoursePackCity(brandId, prov, city, coursePackId);
			if (price != null) {
				return CoursePackWrapper.of(hoPack, price);
			}
		}
		CoursePackSchool schPack = coursePackRepository.getCoursePackSchool(schoolId, coursePackId);
		if (schPack != null) {
			return CoursePackWrapper.of(schPack);
		} else {
			return null;
		}
	}

	public List<CoursePackWrapper> getEnableSchoolPacksWithPrice(String brandId, String prov, String city,
			String schoolId) {
		List<CoursePackWrapper> list = Lists.newArrayList();
		List<CoursePackV2City> cityPrices = coursePackRepository.getEnablePackCity(brandId, prov, city);
		Map<String, CoursePackV2City> priceMap = cityPrices.stream().collect(
				Collectors.toMap(it -> it.getCoursePackId(), it -> it));
		List<CoursePackV2> cpInfos = coursePackRepository.mutiGetEnableCoursePackHoOrder(brandId, priceMap.keySet());
		for (CoursePackV2 cp : cpInfos) {
			CoursePackV2City price = priceMap.get(cp.getCoursePackId());
			if (price == null) {
				continue;
			}
			CoursePackWrapper wrapper = CoursePackWrapper.of(cp, price);
			list.add(wrapper);
		}
		return list;
	}

}
