package com.jz.jar.franchise.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.CourseRepository;
import com.jz.jar.franchise.wrapper.CourseLessonWrapper;
import com.jz.jar.franchise.wrapper.CourseWrapper;
import com.jz.jooq.franchise.tables.pojos.CourseHo;

@Lazy
@Service
public class CourseService {

	@Autowired
	private CourseRepository courseRepository;
	@Autowired
	private CourseFreeSettingService courseFreeSettingService;

	/**
	 * 这里不包含具体lesson信息
	 * */
	public Map<Integer, CourseWrapper> mutiGetCourseInfoMap(String brandId, String schoolId,
			Collection<Integer> courseIds, boolean withLessons) {
		Map<Integer, CourseWrapper> map = Maps.newHashMap();
		List<Integer> officalCourseIds = Lists.newArrayList();
		for (Integer courseId : courseIds) {
			if (courseId < 0) {
				CourseWrapper cw = courseFreeSettingService.getFreeCourseWrapper(brandId, courseId);
				if (cw != null) {
					map.put(courseId, cw);
				}
			} else {
				officalCourseIds.add(courseId);
			}
		}

		List<CourseHo> hos = courseRepository.mutiGetHoCourse(brandId, officalCourseIds);
		if (ArrayMapTools.isNotEmpty(hos)) {
			hos.forEach(it -> {
				map.put(it.getCourseId(), CourseWrapper.ofHo(it));
			});
			if (withLessons) {
				List<CourseLessonWrapper> lessons = courseRepository.mutiGetHoLessons(brandId, officalCourseIds);
				for (CourseLessonWrapper lesson : lessons) {
					if (map.containsKey(lesson.getCourseId())) {
						map.get(lesson.getCourseId()).addLesson(lesson);
					}
				}
			}

		}
		return map;
	}

}
