package com.jz.jar.franchise.wrapper;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.jz.jar.franchise.util.AgeCalUtil;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.pojos.StudentSchool;

public class StudentWrapper {

	// 基础信息
	private Integer code;
	private String suid;
	private String name;
	private String sex;
	private String birthday;
	private Integer age;
	private String engName;
	private String kg;

	// 分校下信息
	private Integer status; // 需要特殊处理
	private Long stopStartTime;
	private Long stopEndTime;
	private UserSimpleWrapper adviser; // 需要特殊处理
	private UserSimpleWrapper teacher; // 需要特殊处理
	private UserSimpleWrapper teacher2; // 需要特殊处理
	private Long firstContractTime;
	private String remark;
	private Integer caseCommNum;
	private Integer stuCommNum;

	// 家长信息
	private String puid;
	private String parentName;
	private String phone;
	private String relation;
	private String address;
	private String district;

	// 合同信息
	private List<StudentContractWrapper> contracts;

	public static StudentWrapper of(StudentInfo si) {
		return new StudentWrapper().setStudentInfo(si);
	}

	public static StudentWrapper of(StudentSchool ss) {
		StudentWrapper wrapper = new StudentWrapper().setSuid(ss.getSuid()).setRemark(ss.getRemark());
		if (ss.getStopStartTime() > 0 && ss.getStopEndTime() > 0) {
			wrapper.setStopStartTime(ss.getStopStartTime()).setStopEndTime(ss.getStopEndTime());
		}
		if (ss.getFirstContractTime() > 0) {
			wrapper.setFirstContractTime(ss.getFirstContractTime());
		}
		wrapper.setCaseCommNum(ss.getCaseCommNum());
		wrapper.setStuCommNum(ss.getStuCommNum());
		return wrapper;
	}

	public StudentWrapper setStudentInfo(StudentInfo si) {
		this.setSuid(si.getSuid()).setCode(si.getCode()).setName(si.getName()).setSex(si.getSex())
				.setBirthday(si.getBirthday()).setEngName(si.getEngName()).setKg(si.getKg());
		;
		if (StringUtils.isNotEmpty(si.getBirthday())) {
			this.setAge(AgeCalUtil.getAge(si.getBirthday()));
		}
		return this;
	}

	public StudentWrapper setParentInfo(ParentInfo pi) {
		return this.setPuid(pi.getPuid()).setParentName(pi.getName()).setPhone(pi.getPhone())
				.setRelation(pi.getRelation()).setAddress(pi.getAddress()).setDistrict(pi.getDistrict());
	}

	public String getSuid() {
		return suid;
	}

	public StudentWrapper setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public StudentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public StudentWrapper setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public StudentWrapper setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public Integer getAge() {
		return age;
	}

	public StudentWrapper setAge(Integer age) {
		this.age = age;
		return this;
	}

	public String getEngName() {
		return engName;
	}

	public StudentWrapper setEngName(String engName) {
		this.engName = engName;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public StudentWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Long getStopStartTime() {
		return stopStartTime;
	}

	public StudentWrapper setStopStartTime(Long stopStartTime) {
		this.stopStartTime = stopStartTime;
		return this;
	}

	public Long getStopEndTime() {
		return stopEndTime;
	}

	public StudentWrapper setStopEndTime(Long stopEndTime) {
		this.stopEndTime = stopEndTime;
		return this;
	}

	public UserSimpleWrapper getAdviser() {
		return adviser;
	}

	public StudentWrapper setAdviser(UserSimpleWrapper adviser) {
		this.adviser = adviser;
		return this;
	}

	public UserSimpleWrapper getTeacher() {
		return teacher;
	}

	public StudentWrapper setTeacher(UserSimpleWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public List<StudentContractWrapper> getContracts() {
		return contracts;
	}

	public StudentWrapper setContracts(List<StudentContractWrapper> contracts) {
		this.contracts = contracts;
		return this;
	}

	public Long getFirstContractTime() {
		return firstContractTime;
	}

	public StudentWrapper setFirstContractTime(Long firstContractTime) {
		this.firstContractTime = firstContractTime;
		return this;
	}

	public String getParentName() {
		return parentName;
	}

	public StudentWrapper setParentName(String parentName) {
		this.parentName = parentName;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public StudentWrapper setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getRelation() {
		return relation;
	}

	public StudentWrapper setRelation(String relation) {
		this.relation = relation;
		return this;
	}

	public String getRemark() {
		return remark;
	}

	public StudentWrapper setRemark(String remark) {
		this.remark = remark;
		return this;
	}

	public String getAddress() {
		return address;
	}

	public StudentWrapper setAddress(String address) {
		this.address = address;
		return this;
	}

	public String getPuid() {
		return puid;
	}

	public StudentWrapper setPuid(String puid) {
		this.puid = puid;
		return this;
	}

	public String getKg() {
		return kg;
	}

	public StudentWrapper setKg(String kg) {
		this.kg = kg;
		return this;
	}

	public String getDistrict() {
		return district;
	}

	public StudentWrapper setDistrict(String district) {
		this.district = district;
		return this;
	}

	public UserSimpleWrapper getTeacher2() {
		return teacher2;
	}

	public StudentWrapper setTeacher2(UserSimpleWrapper teacher2) {
		this.teacher2 = teacher2;
		return this;
	}

	public Integer getCode() {
		return code;
	}

	public StudentWrapper setCode(Integer code) {
		this.code = code;
		return this;
	}

	public Integer getCaseCommNum() {
		return caseCommNum;
	}

	public StudentWrapper setCaseCommNum(Integer caseCommNum) {
		this.caseCommNum = caseCommNum;
		return this;
	}

	public Integer getStuCommNum() {
		return stuCommNum;
	}

	public StudentWrapper setStuCommNum(Integer stuCommNum) {
		this.stuCommNum = stuCommNum;
		return this;
	}

}
