/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.google.common.collect.Maps;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.StudentSchoolContract;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record2;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentSchoolContractRepository
extends FranchiseBaseRepository {
    private static final StudentSchoolContract SSC = Tables.STUDENT_SCHOOL_CONTRACT;

    public Pair<Integer, Integer> getLessionCount(String suid) {
        Result result = this.franchiseCtx.select((SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.TOTAL_OFFICAL_LESSON), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON)).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.eq((Object)suid).and(StudentSchoolContractRepository.SSC.STATUS.ne((Object)-1))}).fetch();
        if (null == result || result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        if (iterator.hasNext()) {
            Record2 it = (Record2)iterator.next();
            return Pair.of((Object)((BigDecimal)it.value1()).intValue(), (Object)((BigDecimal)it.value2()).intValue());
        }
        return null;
    }

    public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids) {
        Result result = this.franchiseCtx.select((SelectField)StudentSchoolContractRepository.SSC.SUID, (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.TOTAL_OFFICAL_LESSON), (SelectField)DSL.sum((Field)StudentSchoolContractRepository.SSC.CONSUME_OFFICAL_LESSON)).from((TableLike)SSC).where(new Condition[]{StudentSchoolContractRepository.SSC.SUID.in(suids).and(StudentSchoolContractRepository.SSC.STATUS.ne((Object)-1))}).fetch();
        if (null == result || result.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        result.forEach(it -> has.put(it.value1(), Pair.of((Object)((BigDecimal)it.value2()).intValue(), (Object)((BigDecimal)it.value3()).intValue())));
        return has;
    }
}

