/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.franchise.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.repository.FranchiseBaseRepository;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.StudentInfo;
import com.jz.jooq.franchise.tables.records.StudentInfoRecord;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class StudentInfoRepository
extends FranchiseBaseRepository {
    private static final StudentInfo SI = Tables.STUDENT_INFO;

    public String getStudentBirthday(String puid, String suid) {
        List days = this.franchiseCtx.select((SelectField)StudentInfoRepository.SI.BIRTHDAY).from((TableLike)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid).and(StudentInfoRepository.SI.PUID.eq((Object)puid))}).fetchInto(String.class);
        return ArrayMapTools.isNotEmpty((Collection)days) ? (String)days.get(0) : null;
    }

    public void addStudent(String puid, String suid, String cnName, String enName, String sex, String birthday) {
        StudentInfoRecord student = new StudentInfoRecord();
        student.setSuid(suid);
        student.setPuid(puid);
        student.setName(cnName);
        student.setSex(sex);
        student.setBirthday(birthday);
        student.setEngName(enName);
        student.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.franchiseCtx.insertInto((Table)SI).set((Record)student).execute();
    }

    public List<com.jz.jooq.franchise.tables.pojos.StudentInfo> getStudents(String puid) {
        return this.franchiseCtx.selectFrom((Table)SI).where(new Condition[]{StudentInfoRepository.SI.PUID.eq((Object)puid)}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
    }

    public com.jz.jooq.franchise.tables.pojos.StudentInfo getStudent(String suid) {
        List studentInfos = this.franchiseCtx.selectFrom((Table)SI).where(new Condition[]{StudentInfoRepository.SI.SUID.eq((Object)suid)}).fetchInto(com.jz.jooq.franchise.tables.pojos.StudentInfo.class);
        return ArrayMapTools.isNotEmpty((Collection)studentInfos) ? (com.jz.jooq.franchise.tables.pojos.StudentInfo)studentInfos.get(0) : null;
    }
}

