package com.jz.jar.franchise.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.franchise.repository.ParentInfoRepository;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;

@Lazy
@Service
public class ParentInfoService {

	@Autowired
	private ParentInfoRepository parentInfoRepository;

	public void savePatentInfo(String puid, String phone) {
		parentInfoRepository.savePatentInfo(puid, phone);
	}

	public ParentInfo getParentInfoForPhone(String phone) {
		return parentInfoRepository.getParentInfoForPhone(phone);
	}

	public void updateAppLogin(String phone) {
		parentInfoRepository.updateAppLogin(phone);
	}
	
	public void updateAddressForUid(String puid, String address) {
		parentInfoRepository.updateAddressForUid(puid, address);
	}
}
