package com.jz.jar.franchise.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Record2;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.jz.jooq.franchise.Tables;

@Lazy
@Repository
public class StudentSchoolContractRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentSchoolContract SSC = Tables.STUDENT_SCHOOL_CONTRACT;

	public Pair<Integer, Integer> getLessionCount(String suid) {
		Result<Record2<BigDecimal, BigDecimal>> result = franchiseCtx
				.select(DSL.sum(SSC.TOTAL_OFFICAL_LESSON), DSL.sum(SSC.CONSUME_OFFICAL_LESSON)).from(SSC)
				.where(SSC.SUID.eq(suid).and(SSC.STATUS.ne(-1))).fetch();
		if (null == result || result.isEmpty())
			return null;
		for (Record2<BigDecimal, BigDecimal> it : result) {
			return Pair.of(it.value1().intValue(), it.value2().intValue());
		}
		return null;
	}

	public Map<String, Pair<Integer, Integer>> getLessionCount(Collection<String> suids) {
		Result<Record3<String, BigDecimal, BigDecimal>> result = franchiseCtx
				.select(SSC.SUID, DSL.sum(SSC.TOTAL_OFFICAL_LESSON), DSL.sum(SSC.CONSUME_OFFICAL_LESSON)).from(SSC)
				.where(SSC.SUID.in(suids).and(SSC.STATUS.ne(-1))).fetch();
		if (null == result || result.isEmpty())
			return Maps.newHashMap();
		Map<String, Pair<Integer, Integer>> has = Maps.newHashMap();
		result.forEach(it -> has.put(it.value1(), Pair.of(it.value2().intValue(), it.value3().intValue())));
		return has;
	}
}
