package com.jz.jar.franchise.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.franchise.Tables;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.records.StudentInfoRecord;

/**
 * @Title StudentInfoRepository
 * @Package com.jz.jar.franchise.repository
 * @author tangjunfeng
 * @date 2018年8月3日 下午3:17:40
 * @version V1.0
 */
@Lazy
@Repository
public class StudentInfoRepository extends FranchiseBaseRepository {

	private static final com.jz.jooq.franchise.tables.StudentInfo SI = Tables.STUDENT_INFO;

	public String getStudentBirthday(String puid, String suid) {
		List<String> days = franchiseCtx.select(SI.BIRTHDAY).from(SI).where(SI.SUID.eq(suid).and(SI.PUID.eq(puid)))
				.fetchInto(String.class);
		return ArrayMapTools.isNotEmpty(days) ? days.get(0) : null;
	}

	public void addStudent(String puid, String suid, String cnName, String enName, String sex, String birthday) {
		StudentInfoRecord student = new StudentInfoRecord();
		student.setSuid(suid);
		student.setPuid(puid);
		student.setName(cnName);
		student.setSex(sex);
		student.setBirthday(birthday);
		student.setEngName(enName);
		student.setCreated(System.currentTimeMillis());
		franchiseCtx.insertInto(SI).set(student).execute();
	}

	public List<StudentInfo> getStudents(String puid) {
		return franchiseCtx.selectFrom(SI).where(SI.PUID.eq(puid)).fetchInto(StudentInfo.class);
	}

	public StudentInfo getStudent(String suid) {
		List<StudentInfo> studentInfos = franchiseCtx.selectFrom(SI).where(SI.SUID.eq(suid))
				.fetchInto(StudentInfo.class);
		return ArrayMapTools.isNotEmpty(studentInfos) ? studentInfos.get(0) : null;
	}
}
