/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.text;

import com.jz.common.utils.text.AbstractStringTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.RandomStringUtils;

public class StringTools
extends AbstractStringTools {
    public static String toString(Object obj) {
        return null != obj ? obj.toString() : null;
    }

    public static String toString(int num) {
        return String.valueOf(num);
    }

    public static String toString(double num) {
        return String.valueOf(num);
    }

    public static String toString(long num) {
        return String.valueOf(num);
    }

    public static String toString(long[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(int[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(short[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(char[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(byte[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(boolean[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(float[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(double[] args) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(args[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(Object[] args) {
        return StringTools.toString(args, "[", "]", ",");
    }

    public static String toString(Object[] args, String prefix, String suffix, String divide) {
        if (args == null) {
            return null;
        }
        int iMax = args.length - 1;
        if (iMax == -1) {
            return prefix + "" + suffix;
        }
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        int i = 0;
        while (true) {
            b.append(String.valueOf(args[i]));
            if (i == iMax) {
                return b.append(suffix).toString();
            }
            b.append(divide);
            ++i;
        }
    }

    public static String toString(Collection<String> args) {
        return StringTools.toString(args, "[", "]", ",");
    }

    public static String toString(Collection<String> args, String prefix, String suffix, String divide) {
        if (args == null) {
            return null;
        }
        int iMax = args.size() - 1;
        if (iMax == -1) {
            return prefix + "" + suffix;
        }
        Iterator<String> its = args.iterator();
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        int i = 0;
        while (true) {
            b.append(String.valueOf(its.next()));
            if (i == iMax) {
                return b.append(suffix).toString();
            }
            b.append(divide).append("");
            ++i;
        }
    }

    public static String toSqlIn(Collection<String> args) {
        return StringTools.toString(args, "('", "')", "','");
    }

    public static int toInt(Object arg0) {
        try {
            return Integer.valueOf(StringTools.toString(arg0));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static int toInt(String arg0) {
        try {
            return Integer.valueOf(arg0);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static long toLong(Object arg0) {
        try {
            return Long.valueOf(StringTools.toString(arg0));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static long toLong(String arg0) {
        try {
            return Long.valueOf(arg0);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static double toDouble(Object arg0) {
        try {
            return Double.valueOf(StringTools.toString(arg0));
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static double toDouble(String arg0) {
        try {
            return Double.valueOf(arg0);
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static String replace(String arg0, CharSequence newChar, String ... filter) {
        for (String fi : filter) {
            if (!arg0.contains(fi)) continue;
            arg0 = arg0.replace(fi, newChar);
        }
        return arg0;
    }

    public static boolean allEmpty(String ... args) {
        if (null != args && args.length > 0) {
            for (String arg : args) {
                if (!StringTools.isNotEmpty((CharSequence)arg)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allNotEmpty(String ... args) {
        if (null != args && args.length > 0) {
            for (String arg : args) {
                if (!StringTools.isEmpty((CharSequence)arg)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean contains(String arg0, Set<Enum> args) {
        if (StringTools.isNotEmpty((CharSequence)arg0) && null != args && args.size() > 0) {
            for (Enum e : args) {
                if (!arg0.equalsIgnoreCase(e.name())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String arg0, Enum<?> ... args) {
        if (StringTools.isNotEmpty((CharSequence)arg0) && null != args && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!arg0.equalsIgnoreCase(args[i].name())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enum<?> ... args) {
        if (null != args && args.length > 0) {
            for (int i = 1; i < args.length; ++i) {
                if (args[0] != args[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String arg0, String[] args) {
        if (StringTools.isNotEmpty((CharSequence)arg0) && null != args && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (!arg0.equalsIgnoreCase(args[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(String ... args) {
        if (null != args && args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (!args[0].equalsIgnoreCase(args[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(String ... args) {
        if (null != args && args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (args[0].indexOf(args[i]) >= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean contains(int ... args) {
        if (null != args && args.length > 1) {
            for (int i = 1; i < args.length; ++i) {
                if (args[0] != args[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static String getExceptionText(Exception e) {
        StringWriter w = new StringWriter();
        e.printStackTrace(new PrintWriter(w));
        return ((Object)w).toString();
    }

    public static String twoDigits(int num) {
        return num > 9 ? num + "" : "0" + num;
    }

    public static String ternary(String arg0, String defaultValue) {
        return StringTools.isNotEmpty((CharSequence)arg0) ? arg0 : defaultValue;
    }

    public static String ternary(String arg0) {
        return StringTools.ternary(arg0, "");
    }

    public static String ternary(Object arg0, String defaultValue) {
        return StringTools.isEmpty(arg0) ? defaultValue : StringTools.toString(arg0);
    }

    public static String ternary(Object arg0) {
        return StringTools.isEmpty(arg0) ? "" : StringTools.toString(arg0);
    }

    public static <T> T ternary(boolean bool, T trueVal, T falseVal) {
        return bool ? trueVal : falseVal;
    }

    public static boolean mustLength(int length, String ... args) {
        for (String arg0 : args) {
            if (arg0 != null && arg0.length() >= length) continue;
            return false;
        }
        return true;
    }

    public static boolean moreThan(int min, String ... args) {
        return StringTools.mustLength(min, args);
    }

    public static boolean lessThan(int max, String ... args) {
        for (String arg0 : args) {
            if (arg0 != null && arg0.length() <= max) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(int len, String ... args) {
        for (String arg0 : args) {
            if (arg0 != null && arg0.length() == len) continue;
            return false;
        }
        return true;
    }

    public static boolean allBlank(String ... args) {
        if (null != args && args.length > 0) {
            for (String arg : args) {
                if (!StringTools.isNotBlank((CharSequence)arg)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allNotBlank(String ... args) {
        if (null != args && args.length > 0) {
            for (String arg : args) {
                if (!StringTools.isBlank((CharSequence)arg)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyAndBlank(String arg0) {
        return !StringTools.isNotEmptyAndBlank(arg0);
    }

    public static boolean isNotEmptyAndBlank(String arg0) {
        return StringTools.isNotEmpty((CharSequence)arg0) && StringTools.isNotBlank((CharSequence)arg0);
    }

    public static boolean allEmptyAndBlank(String ... args) {
        if (null == args || args.length <= 0) {
            return true;
        }
        for (String arg : args) {
            if (!StringTools.isNotEmpty((CharSequence)arg) && !StringTools.isNotBlank((CharSequence)arg)) continue;
            return false;
        }
        return true;
    }

    public static boolean allNotEmptyAndBlank(String ... args) {
        if (null == args || args.length <= 0) {
            return false;
        }
        for (String arg : args) {
            if (!StringTools.isEmpty((CharSequence)arg) && !StringTools.isBlank((CharSequence)arg)) continue;
            return false;
        }
        return true;
    }

    public static class RandomString {
        public static String random(int len) {
            return RandomString.random(len, true, true);
        }

        public static String random(int len, boolean numbers, boolean letters) {
            return RandomStringUtils.random((int)len, (boolean)letters, (boolean)numbers);
        }

        public static String numbers(int len) {
            return RandomString.random(len, true, false);
        }

        public static String letters(int len) {
            return RandomString.random(len, false, true);
        }

        public static String letterLower(int len) {
            return RandomString.random(len, false, true).toLowerCase();
        }

        public static String letterUpper(int len) {
            return RandomString.random(len, false, true).toUpperCase();
        }

        public static String lower(int len) {
            return RandomString.random(len, true, true).toLowerCase();
        }

        public static String upper(int len) {
            return RandomString.random(len, true, true).toUpperCase();
        }
    }
}

