/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.jz;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerialNoGenerator {
    private static final String ABCABC = "^(\\d{3})\\1$";
    private static final String AABBCC = "^(\\d)\\1(\\d)\\2(\\d)\\3$";
    private static final String AAXBBX = "^(\\d)\\1\\d(\\d)\\2\\d$";
    private static final String LOVE6S = "^(520|521|1314|3344)\\d+$";
    private static final String ABCABCX = "^(\\d{3})\\1\\d$";
    private static final String ABABABC = "^(\\d{2})\\1\\1\\d$";
    private static final String AABBCCX = "^(\\d)\\1(\\d)\\2(\\d)\\3\\d$";
    private static final String XAABBCC = "^\\d(\\d)\\1(\\d)\\2(\\d)\\3$";
    private static final String AAABBBC = "^(\\d)\\1\\1(\\d)\\2\\2\\d$";
    private static final String CAAABBB = "^\\d(\\d)\\1\\1(\\d)\\2\\2$";
    private static final String AAAXBBB = "^(\\d)\\1\\1\\d(\\d)\\2\\2$";
    private static final String[] seeds_3 = new String[]{"111", "222", "333", "444", "555", "666", "777", "888", "999", "000"};
    private static final String[] seeds_4 = new String[]{"1111", "2222", "3333", "4444", "5555", "6666", "7777", "8888", "9999", "0000"};
    private static final String[] seeds_5 = new String[]{"11111", "22222", "33333", "44444", "55555", "66666", "77777", "88888", "99999", "00000"};
    private static final String[] seeds_6 = new String[]{"111111", "222222", "333333", "444444", "555555", "666666", "777777", "888888", "999999", "000000"};
    private static final String[] seeds_7 = new String[]{"1111111", "2222222", "3333333", "4444444", "5555555", "6666666", "7777777", "8888888", "9999999", "0000000"};
    private static final String[] seeds_8 = new String[]{"11111111", "22222222", "33333333", "44444444", "55555555", "66666666", "77777777", "88888888", "99999999", "00000000"};
    private static final String[] seeds_9 = new String[]{"111111111", "222222222", "333333333", "444444444", "555555555", "666666666", "777777777", "888888888", "999999999", "000000000"};
    private static final String[] specialNumbers_4 = new String[]{"1234", "2345", "3456", "4567", "5678", "6789", "7890", "9876", "8765", "7654", "6543", "5432", "4321"};
    private static final String[] specialNumbers_5 = new String[]{"12345", "23456", "34567", "45678", "56789", "98765", "87654", "76543", "65432", "54321"};
    private static final String[] specialNumbers_6 = new String[]{"123456", "234567", "345678", "456789", "987654", "876543", "765432", "654321"};
    private static final String[] specialNumbers_7 = new String[]{"1234567", "2345678", "3456789", "9876543", "8765432", "7654321"};
    private static final String[] specialNumbers_8 = new String[]{"12345678", "23456789", "34567890", "98765432", "87654321", "76543210"};
    private static final String[] specialNumbers_9 = new String[]{"123456789", "234567890", "987654321", "876543210"};
    private static final int minSerialNo = 100000;
    private static final int maxSerialNo = 999999999;

    public static Integer generateNormalSerialNo(Integer start) {
        List<Integer> serialNo = SerialNoGenerator.batchGenerateNormalSerialNo(start, 1);
        return ArrayMapTools.isNotEmpty(serialNo) ? serialNo.get(0) : null;
    }

    public static List<Integer> batchGenerateNormalSerialNo(int start, int size) {
        if (start < 100000 || size <= 0 || start > 999999999) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        String tempSerialNo = null;
        for (int i = start; i <= 999999999 && results.size() < size; ++i) {
            tempSerialNo = String.valueOf(i);
            if (SerialNoGenerator.isDuplicateCount(tempSerialNo) || SerialNoGenerator.isOrderNumer(tempSerialNo) || SerialNoGenerator.isSameChars(tempSerialNo) || SerialNoGenerator.isCustomStyleNumber(tempSerialNo)) continue;
            results.add(i);
        }
        return results;
    }

    public static List<Integer> batchGenerateBeautifulSerialNo(int start, int size) {
        if (start < 100000 || start > 999999999 || size <= 0) {
            return null;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        String tempSerialNo = null;
        for (int i = start; i <= 999999999 && results.size() < size; ++i) {
            tempSerialNo = String.valueOf(i);
            if (SerialNoGenerator.isDuplicateCount(tempSerialNo)) {
                results.add(i);
                continue;
            }
            if (SerialNoGenerator.isOrderNumer(tempSerialNo)) {
                results.add(i);
                continue;
            }
            if (SerialNoGenerator.isSameChars(tempSerialNo)) {
                results.add(i);
                continue;
            }
            if (!SerialNoGenerator.isCustomStyleNumber(tempSerialNo)) continue;
            results.add(i);
        }
        return results;
    }

    private static boolean isOrderNumer(String serialNo) {
        return SerialNoGenerator.traverseSeeds(specialNumbers_4, serialNo) || SerialNoGenerator.traverseSeeds(specialNumbers_5, serialNo) || SerialNoGenerator.traverseSeeds(specialNumbers_6, serialNo) || SerialNoGenerator.traverseSeeds(specialNumbers_7, serialNo) || SerialNoGenerator.traverseSeeds(specialNumbers_8, serialNo) || SerialNoGenerator.traverseSeeds(specialNumbers_9, serialNo);
    }

    private static boolean isSameChars(String srcNumber) {
        if (srcNumber.length() == 6 && (SerialNoGenerator.traverseSeeds(seeds_3, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_4, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_5, srcNumber))) {
            return true;
        }
        return SerialNoGenerator.traverseSeeds(seeds_4, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_5, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_6, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_7, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_8, srcNumber) || SerialNoGenerator.traverseSeeds(seeds_9, srcNumber);
    }

    private static boolean isDuplicateCount(String serialNo) {
        if (StringTools.isEmpty((CharSequence)serialNo) || StringTools.isBlank((CharSequence)serialNo)) {
            return false;
        }
        int half = serialNo.length() / 2;
        if (serialNo.length() % 2 == 0) {
            --half;
        }
        return SerialNoGenerator.getNotDuplicateCount(serialNo) <= half;
    }

    private static boolean traverseSeeds(String[] seeds, String src) {
        boolean result = false;
        for (String s : seeds) {
            if (src.indexOf(s) <= -1) continue;
            result = true;
            break;
        }
        return result;
    }

    private static int getNotDuplicateCount(String serialNo) {
        HashSet<Character> counter = new HashSet<Character>();
        for (char temp : serialNo.toCharArray()) {
            counter.add(Character.valueOf(temp));
        }
        return counter.size();
    }

    private static boolean isCustomStyleNumber(String src) {
        if (src.length() == 6 && (SerialNoGenerator.matcherRegx(ABCABC, src) || SerialNoGenerator.matcherRegx(AABBCC, src) || SerialNoGenerator.matcherRegx(AAXBBX, src) || SerialNoGenerator.matcherRegx(LOVE6S, src))) {
            return true;
        }
        return SerialNoGenerator.matcherRegx(ABCABCX, src) || SerialNoGenerator.matcherRegx(ABABABC, src) || SerialNoGenerator.matcherRegx(AABBCCX, src) || SerialNoGenerator.matcherRegx(XAABBCC, src) || SerialNoGenerator.matcherRegx(AAABBBC, src) || SerialNoGenerator.matcherRegx(CAAABBB, src) || SerialNoGenerator.matcherRegx(AAAXBBB, src) || SerialNoGenerator.matcherRegx(LOVE6S, src);
    }

    private static boolean matcherRegx(String regx, String src) {
        Pattern p = Pattern.compile(regx);
        Matcher m = p.matcher(src);
        return m.matches();
    }
}

