/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http.v2;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.v2.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletPost
extends HttpServletRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletPost.class);

    public static String send(String url) {
        return HttpServletPost.send(url, null);
    }

    public static String send(String url, Map<String, String> params) {
        return HttpServletPost.send(url, params, "UTF-8", null, true);
    }

    public static String send(String url, Map<String, String> params, String charsetName) {
        return HttpServletPost.send(url, params, charsetName, null, true);
    }

    public static String send(String url, Map<String, String> params, boolean showLog) {
        return HttpServletPost.send(url, params, "UTF-8", null, showLog);
    }

    public static String send(String url, Map<String, String> params, Map<String, String> header) {
        return HttpServletPost.send(url, params, "UTF-8", header, true);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) {
        return HttpServletPost.send(url, params, "UTF-8", header, true);
    }

    public static String send(String url, Map<String, String> params, Map<String, String> header, boolean showLog) {
        return HttpServletPost.send(url, params, "UTF-8", header, showLog);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header, boolean showLog) {
        if (showLog) {
            logger.info("POST : {}{}{}", new Object[]{url, url.indexOf("?") > 0 ? "&" : "?", params});
        }
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        if (ArrayMapTools.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        try {
            return HttpServletPost.sendPost((HttpEntity)new UrlEncodedFormEntity(parameters, charsetName), url, charsetName, header, showLog);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sendBody(String url, String body) {
        return HttpServletPost.sendBody(url, body, "UTF-8", null, true);
    }

    public static String sendBody(String url, String body, String charsetName) {
        return HttpServletPost.sendBody(url, body, charsetName, null, true);
    }

    public static String sendBody(String url, String body, boolean showLog) {
        return HttpServletPost.sendBody(url, body, "UTF-8", null, showLog);
    }

    public static String sendBody(String url, String body, Map<String, String> header) {
        return HttpServletPost.sendBody(url, body, "UTF-8", header, true);
    }

    public static String sendBody(String url, String body, Map<String, String> header, boolean showLog) {
        return HttpServletPost.sendBody(url, body, "UTF-8", header, showLog);
    }

    public static String sendBody(String url, String body, String charsetName, Map<String, String> header, boolean showLog) {
        if (showLog) {
            logger.info("POST : {}, BODY : {}", (Object)url, (Object)body);
        }
        try {
            return HttpServletPost.sendPost((HttpEntity)new StringEntity(body, charsetName), url, charsetName, header, showLog);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String sendPost(HttpEntity entity, String url, String charsetName, Map<String, String> header, boolean showLog) throws IOException {
        HttpPost post = new HttpPost(url);
        post.setEntity(entity);
        return HttpServletPost.sendHttpRequest((HttpRequestBase)post, charsetName, header, (Logger)(showLog ? logger : null));
    }
}

