package com.jz.common.utils.text;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang3.RandomStringUtils;

/**
 * @Title StringUtils.java
 * @Package com.waqu.common.utils
 * @author Administrator
 * @date 2015年5月5日 下午6:11:35
 * @version V1.0
 */
public class StringTools extends AbstractStringTools {

	public static String toString(Object obj) {
		return null != obj ? obj.toString() : null;
	}

	public static String toString(int num) {
		return String.valueOf(num);
	}

	public static String toString(double num) {
		return String.valueOf(num);
	}

	public static String toString(long num) {
		return String.valueOf(num);
	}

	public static String toString(long[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(int[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(short[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(char[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(byte[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(boolean[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(float[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(double[] args) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return "[]";

		StringBuilder b = new StringBuilder();
		b.append('[');
		for (int i = 0;; i++) {
			b.append(args[i]);
			if (i == iMax)
				return b.append(']').toString();
			b.append(", ");
		}
	}

	public static String toString(Object[] args) {
		return toString(args, "[", "]", ",");
	}

	/**
	 * 将集合内容转换成指定字符串格式
	 * 
	 * @Title toString
	 * @param args   需要转换的集合
	 * @param prefix 前缀
	 * @param suffix 后缀
	 * @param divide 分隔符
	 * @return String
	 */
	public static String toString(Object[] args, String prefix, String suffix, String divide) {
		if (args == null)
			return null;
		int iMax = args.length - 1;
		if (iMax == -1)
			return prefix + "" + suffix;

		StringBuilder b = new StringBuilder();
		b.append(prefix);
		for (int i = 0;; i++) {
			b.append(String.valueOf(args[i]));
			if (i == iMax)
				return b.append(suffix).toString();
			b.append(divide);
		}
	}

	public static String toString(Collection<String> args) {
		return toString(args, "[", "]", ",");
	}

	/**
	 * 将集合内容转换成指定字符串格式
	 * 
	 * @Title toString
	 * @param args   需要转换的集合
	 * @param prefix 前缀
	 * @param suffix 后缀
	 * @param divide 分隔符
	 * @return String
	 */
	public static String toString(Collection<String> args, String prefix, String suffix, String divide) {
		if (args == null)
			return null;
		int iMax = args.size() - 1;
		if (iMax == -1)
			return prefix + "" + suffix;

		Iterator<String> its = args.iterator();
		StringBuilder b = new StringBuilder();
		b.append(prefix);
		for (int i = 0;; i++) {
			b.append(String.valueOf(its.next()));
			if (i == iMax)
				return b.append(suffix).toString();
			b.append(divide).append("");
		}
	}

	/**
	 * 将指定字符串转换成SQL语句中的IN内容格式
	 * 
	 * @Title toSqlIn
	 * @Description 如：toSqlIn( [1,2,3,4,5] )<br/>
	 *              返回 ('1','2','3','4','5')
	 * @param args
	 * @return String
	 */
	public static String toSqlIn(Collection<String> args) {
		return toString(args, "('", "')", "','");
	}

	public static class RandomString {

		public static String random(int len) {
			return random(len, true, true);
		}

		public static String random(int len, boolean numbers, boolean letters) {
			return RandomStringUtils.random(len, letters, numbers);
		}

		public static String numbers(int len) {
			return random(len, true, false);
		}

		public static String letters(int len) {
			return random(len, false, true);
		}

		public static String letterLower(int len) {
			return random(len, false, true).toLowerCase();
		}

		public static String letterUpper(int len) {
			return random(len, false, true).toUpperCase();
		}

		public static String lower(int len) {
			return random(len, true, true).toLowerCase();
		}

		public static String upper(int len) {
			return random(len, true, true).toUpperCase();
		}
	}

	public static int toInt(Object arg0) {
		try {
			return Integer.valueOf(toString(arg0));
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	public static int toInt(String arg0) {
		try {
			return Integer.valueOf(arg0);
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	public static long toLong(Object arg0) {
		try {
			return Long.valueOf(toString(arg0));
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	public static long toLong(String arg0) {
		try {
			return Long.valueOf(arg0);
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	public static double toDouble(Object arg0) {
		try {
			return Double.valueOf(toString(arg0));
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	public static double toDouble(String arg0) {
		try {
			return Double.valueOf(arg0);
		} catch (NumberFormatException e) {
			return -1;
		}
	}

	/**
	 * 替换字符串中的特殊字符
	 * 
	 * @param arg0    需要替换的字符串
	 * @param newChar 查找到特殊字符后替换内容
	 * @param filter  需要替换的特殊字符
	 * @return String
	 */
	public static String replace(String arg0, CharSequence newChar, String... filter) {
		for (String fi : filter) {
			if (arg0.contains(fi))
				arg0 = arg0.replace(fi, newChar);
		}
		return arg0;
	}

	public static boolean allEmpty(String... args) {
		if (null != args && args.length > 0) {
			for (String arg : args) {
				if (isNotEmpty(arg))
					return false;
			}
		}
		return true;
	}

	public static boolean allNotEmpty(String... args) {
		if (null != args && args.length > 0) {
			for (String arg : args) {
				if (isEmpty(arg))
					return false;
			}
			return true;
		}
		return false;
	}

	@SuppressWarnings("rawtypes")
	public static boolean contains(String arg0, Set<Enum> args) {
		if (isNotEmpty(arg0) && null != args && args.size() > 0) {
			for (Enum e : args) {
				if (arg0.equalsIgnoreCase(e.name()))
					return true;
			}
		}
		return false;
	}

	public static boolean contains(String arg0, Enum<?>... args) {
		if (isNotEmpty(arg0) && null != args && args.length > 0) {
			for (int i = 0; i < args.length; i++) {
				if (arg0.equalsIgnoreCase(args[i].name()))
					return true;
			}
		}
		return false;
	}
	
	public static boolean contains(Enum<?>... args) {
		if (null != args && args.length > 0) {
			for (int i = 1; i < args.length; i++) {
				if (args[0] == args[i])
					return true;
			}
		}
		return false;
	}
	
	public static boolean contains(String arg0, String[] args) {
		if (isNotEmpty(arg0) && null != args && args.length > 0) {
			for (int i = 0; i < args.length; i++) {
				if (arg0.equalsIgnoreCase(args[i]))
					return true;
			}
		}
		return false;
	}

	public static boolean contains(String... args) {
		if (null != args && args.length > 1) {
			for (int i = 1; i < args.length; i++) {
				if (args[0].equalsIgnoreCase(args[i]))
					return true;
			}
		}
		return false;
	}

	public static boolean containsAll(String... args) {
		if (null != args && args.length > 1) {
			for (int i = 1; i < args.length; i++) {
				if (args[0].indexOf(args[i]) < 0)
					return false;
			}
			return true;
		}
		return false;
	}

	public static boolean contains(int... args) {
		if (null != args && args.length > 1) {
			for (int i = 1; i < args.length; i++) {
				if (args[0] == args[i])
					return true;
			}
		}
		return false;
	}

	/** 取得异常对象的错误描述文本 */
	public static String getExceptionText(Exception e) {
		Writer w = new StringWriter();
		e.printStackTrace(new PrintWriter(w));
		return w.toString();
	}

	/** 将数字转换成两位数 */
	public static String twoDigits(int num) {
		return num > 9 ? num + "" : "0" + num;
	}

	public static String ternary(String arg0, String defaultValue) {
		return isNotEmpty(arg0) ? arg0 : defaultValue;
	}

	public static String ternary(String arg0) {
		return ternary(arg0, "");
	}

	public static String ternary(Object arg0, String defaultValue) {
		return isEmpty(arg0) ? defaultValue : toString(arg0);
	}

	public static String ternary(Object arg0) {
		return isEmpty(arg0) ? "" : toString(arg0);
	}

	public static <T> T ternary(boolean bool, T trueVal, T falseVal) {
		return bool ? trueVal : falseVal;
	}

	public static boolean mustLength(int length, String... args) {
		for (String arg0 : args) {
			if (arg0 == null || arg0.length() < length)
				return false;
		}
		return true;
	}

	/**
	 * <b>比对字符串长度是否高于指定数字</b><br/>
	 * moreThan(1, "a") false<br/>
	 * moreThan(1, "ab") true<br/>
	 * moreThan(1, "ab", null) false<br/>
	 * moreThan(2, "ab", "cd") false<br/>
	 * moreThan(2, "abc", "cd") false<br/>
	 * moreThan(2, "abc", "cde") true<br/>
	 */
	public static boolean moreThan(int min, String... args) {
		return mustLength(min, args);
	}

	/**
	 * <b>比对字符串长度是否低于指定数字</b><br/>
	 * lessThan(1, "a") true<br/>
	 * lessThan(1, " ") true<br/>
	 * lessThan(1, null) false<br/>
	 * lessThan(1, "ab") false<br/>
	 * lessThan(2, "ab", "cd") true<br/>
	 * lessThan(2, "ab", "cde") false<br/>
	 */
	public static boolean lessThan(int max, String... args) {
		for (String arg0 : args) {
			if (arg0 == null || arg0.length() > max)
				return false;
		}
		return true;
	}

	/**
	 * <b>比对字符串长度是否等于指定数字</b><br/>
	 * equal(1, "a") true<br/>
	 * equal(1, null, "a") false<br/>
	 * equal(1, "D", null, "a") false<br/>
	 * equal(1,"ab") false<br/>
	 * equal(2,"ab","cd") true<br/>
	 * equal(2,"ab","cde") false<br/>
	 */
	public static boolean equal(int len, String... args) {
		for (String arg0 : args) {
			if (arg0 == null || arg0.length() != len)
				return false;
		}
		return true;
	}

	public static boolean allBlank(String... args) {
		if (null != args && args.length > 0) {
			for (String arg : args) {
				if (isNotBlank(arg))
					return false;
			}
		}
		return true;
	}

	public static boolean allNotBlank(String... args) {
		if (null != args && args.length > 0) {
			for (String arg : args) {
				if (isBlank(arg))
					return false;
			}
			return true;
		}
		return false;
	}

	public static boolean isEmptyAndBlank(String arg0) {
		return !isNotEmptyAndBlank(arg0);
	}

	public static boolean isNotEmptyAndBlank(String arg0) {
		return isNotEmpty(arg0) && isNotBlank(arg0);
	}

	public static boolean allEmptyAndBlank(String... args) {
		if (null == args || args.length <= 0)
			return true;
		for (String arg : args) {
			if (isNotEmpty(arg) || isNotBlank(arg))
				return false;
		}
		return true;
	}

	public static boolean allNotEmptyAndBlank(String... args) {
		if (null == args || args.length <= 0)
			return false;
		for (String arg : args) {
			if (isEmpty(arg) || isBlank(arg))
				return false;
		}
		return true;
	}
}
