package com.jz.common.utils.text;

import java.util.HashMap;
import java.util.Map;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

/** 
 * @Title FormulaEngineTools.java
 * @Package com.waqu.common.utils.text
 * @author tangjunfeng
 * @date 2016年7月21日 上午11:32:45
 * @version V1.0
 */
public class FormulaEngineTools {
	
	private static final ScriptEngine jse = new ScriptEngineManager().getEngineByName("JS");
	
	static { // 预热当前处理方案
		try {
			jse.eval("1000 * 0.8 / 0.2");
		} catch (ScriptException e) {
		}
	}
	
	/***
	 * 执行字符串公式并返回结果
	 * @param script 需要执行的字符串公式
	 * @return 公式执行结果<br/>如：公式 = 1000 * 0.2，返回200.0
	 */
	public static Object eval(String script) throws ScriptException {
		return jse.eval(script);
	}
	
	/***
	 * 执行字符串公式并返回结果
	 * @param script 需要执行的字符串公式
	 * @param params 公式中的非数字内容
	 * @return 公式执行结果<br/>如：公式 = X * 0.2，params = (X, 1000) 返回200.0
	 */
	public static Object eval(String script, Map<String, Object> params) throws ScriptException {
		Bindings bindings = jse.createBindings(); // 创建新的参数列表
		params.forEach((k, v)-> { // 设置新参数
			bindings.put(k, v);
		});
		// 使用新参数执行相关结果
		return jse.eval(script, bindings);
	}
	
	public static void main(String[] args) {
		try {
			System.out.println(FormulaEngineTools.eval("1000 * 0.2"));
			Map<String, Object> params = new HashMap<>();
			params.put("X", 1000);
			System.out.println(FormulaEngineTools.eval("X * 0.2", params));
		} catch (ScriptException e) {
			e.printStackTrace();
		}
	}
}
